CREATE view emp_high_sal
AS SELECT /*+ use_index(employees) */ employee_id, first_name, last_name, salary
   FROM employees
   WHERE salary > 10000;

CREATE or replace view dept_sal
AS SELECT /*+ full(employees) */
     department_id, department_name, departments.manager_id, SUM(salary) total_salary, AVG(salary) avg_salary
   FROM employees JOIN departments USING(department_id)
   GROUP BY department_id, department_name, departments.manager_id;

SELECT * FROM emp_high_sal;

SELECT /*+ full(employees) */
  department_id, department_name,
  departments.manager_id, SUM(salary) total_salary, AVG(salary) avg_salary
FROM employees JOIN departments USING(department_id)
GROUP BY department_id, department_name, departments.manager_id;

SELECT manager_id, sum(total_salary)
FROM dept_sal
GROUP BY manager_id;