create table sklepy(
  id_sklepu number(10) not null,
  nazwa_dostawcy varchar2(40) not null,
  constraint sklepy_pk PRIMARY KEY (id_sklepu)
);

create table produkty(
  id_produktu number(10) not null,
  nazwa_produktu varchar2(30) not null,
  id_dostawcy number(10) not null,
  id_sklepu number(10) not null,
  constraint fk_sklepy
  foreign key (id_sklepu)
  references sklepy(id_sklepu)
  on delete cascade
);

create index fk_sklepy on produkty(id_sklepu);

select * from (
  select ct.table_name, co.column_name, co.position column_position
  from   user_constraints ct, user_cons_columns co
  where  ct.constraint_name = co.constraint_name
    and  ct.constraint_type = 'R'
  minus
  select ui.table_name, uic.column_name, uic.column_position
  from   user_indexes ui, user_ind_columns uic
  where  ui.index_name = uic.index_name
)
order by table_name, column_position;
