create or replace package sklepy_pakiet is
  type rekord_sklep is record (
     nazwa_sklepu sklepy.nazwa_sklepu%TYPE,
     kierownik pracownicy.nazwisko%type,
     wielkosc_sklepu PLS_INTEGER
);
function pobierz_info_o_sklepie(id_sklepu PLS_INTEGER)
RETURN rekord_sklep
RESULT_CACHE;
END sklepy_pakiet;
/

create or replace package body sklepy_pakiet is
  FUNCTION pobierz_info_o_sklepie(id_sklepu PLS_INTEGER)
  RETURN rekord_sklep
  RESULT_CACHE RELIES_ON (sklepy, pracownicy)
  IS
     rek rekord_sklep;
  BEGIN
     SELECT nazwa_sklepu INTO rek.nazwa_sklepu
     FROM sklepy
     WHERE id_sklepu = id_sklepu;
     SELECT p.nazwisko INTO rek.kierownik
     FROM sklepy s, pracownicy p
     WHERE s.id_sklepu = id_sklepu
     AND s.id_kierownika = p.id_pracownika;
     SELECT COUNT(*) INTO rek.wielkosc_sklepu
     FROM PRACOWNICY
     WHERE id_sklepu = id_sklepu;
     RETURN rek;
   END pobierz_info_o_sklepie;
END sklepy_pakiet;
/

execute sklepy_pakiet.pobierz_info_o_sklepie(999)

execute DBMS_RESULT_CACHE.bypass(true);
execute DBMS_RESULT_CACHE.flush;
alter package sklepy_pakiet compile;
execute DBMS_RESULT_CACHE.bypass(false);