SELECT
  'Nazwa zadania     : ' || f.task_name || chr(10) ||
  'Nazwa segmentu    : ' || o.attr2     || chr(10) ||
  'Typ segmentu      : ' || o.type      || chr(10) ||
  'Nazwa partycji    : ' || o.attr3     || chr(10) ||
  'Komunikat         : ' || f.message   || chr(10) ||
  'Wicej informacji : ' || f.more_info PORADA
FROM
  dba_advisor_findings f,
  dba_advisor_objects o
WHERE
  o.task_id = f.task_id
  AND o.object_id = f.object_id
  AND f.task_name like '&task_name'
ORDER BY f.task_name;

alter table pracownicy move pctfree 5;

select owner, index_name, status
from dba_indexes
where table_name='PRACOWNICY';

alter index pracownicy_pk rebuild;

analyze table pracownicy list chained rows;

select count(*) from chained_rows where table_name='PRACOWNICY';

create table pracownicy_tymcz as
  select *
  from pracownicy
  where rowid in
   (select head_rowid from chained_rows where table_name = 'PRACOWNICY');

delete from pracownicy
where rowid in
  (select head_rowid from chained_rows where table_name = 'PRACOWNICY');
  
insert into pracownicy select * from pracownicy_tymcz;

select rowid, id_pracownika from pracownicy;

select
  id_pracownika,
  dbms_rowid.rowid_to_absolute_fno(rowid,schema_name=>'SERWIS',object_name=>'PRACOWNICY') file_num,
  dbms_rowid.rowid_block_number(rowid) block_num,
  dbms_rowid.rowid_row_number(rowid) row_num
from pracownicy;
