CREATE MATERIALIZED VIEW DEPT_SAL_MV
ENABLE QUERY REWRITE
AS
  SELECT
    department_id,
    SUM(nvl(salary+(salary*commission_pct),salary)) total_compensation
  FROM employees
  GROUP BY department_id;

SELECT /*+ rewrite(dept_sal_mv) */
  department_id,
  SUM(NVL(salary+(salary*commission_pct),salary)) total_compensation
FROM employees
GROUP BY department_id
HAVING SUM(NVL(salary+(salary*commission_pct),salary)) > 10000
ORDER by 2;

SELECT /*+ rewrite */
  department_id,
  SUM(NVL(salary+(salary*commission_pct),salary)) total_compensation
FROM employees
GROUP BY department_id
HAVING SUM(NVL(salary+(salary*commission_pct),salary)) > 10000
ORDER by 2;

SELECT /*+ norewrite */
  department_id,
  SUM(NVL(salary+(salary*commission_pct),salary)) total_compensation
FROM employees
GROUP BY department_id
HAVING SUM(NVL(salary+(salary*commission_pct),salary)) > 10000
ORDER by 2;
