DECLARE
  tune_task VARCHAR2(30);
  tune_sql CLOB;
BEGIN
  tune_sql := 'select a.emp_id, b.dept_name ' ||
              'from emp a, dept b ' ||
              'where a.dept_id = b.dept_id';
  --
  tune_task := DBMS_SQLTUNE.CREATE_TUNING_TASK(
    sql_text => tune_sql,
    user_name => 'SERWIS',
    scope => 'COMPREHENSIVE',
    time_limit => 60,
    task_name => 'zadanie_testowe5',
    description => 'Regulacja zapytania SQL.'
  );
END;
/

exec dbms_sqltune.execute_tuning_task(task_name => 'zadanie_testowe5');

set long 10000 longchunksize 10000 linesize 132 pagesize 200
select dbms_sqltune.report_tuning_task('zadanie_testowe5') from dual;
