SELECT last_name, first_name, department_name dept, salary
FROM employees e join
  (SELECT department_id, max(salary) high_sal
   FROM employees
   GROUP BY department_id ) m
USING (department_id) join departments
USING (department_id)
WHERE e.salary = m.high_sal
ORDER BY SALARY desc;

WITH service_info AS
  (SELECT
     product_id,
     geographic_id,
     sum(qty) quantity
   FROM services
   GROUP BY
     product_id,
     geographic_id),
  product_info AS
    (SELECT product_id, product_group, product_desc
     FROM products
     WHERE source_sys = 'BILLING'),
  billing_info AS
    (SELECT journal_date, billing_date, product_id
     FROM BILLING
     WHERE journal_date = TO_DATE('2013-08-15', 'YYYY-MM-DD'))
SELECT
  product_group,
  product_desc,
  journal_date,
  billing_date,
  sum(service_info.quantity)
FROM service_info JOIN product_info
  ON service_info.product_id = product_info.product_id JOIN billing_info
  ON  service_info.product_id = billing_info.product_id
WHERE
  service_info.quantity > 0
GROUP BY
  product_group,
  product_desc,
  journal_date,
  billing_date;