CREATE TABLE klienci(
  id_klienta NUMBER,
  nazwisko VARCHAR2(30),
  imie VARCHAR2(30))
TABLESPACE dane_kadrowe;
--
ALTER TABLE klienci ADD CONSTRAINT klienci_pk PRIMARY KEY (id_klienta)
USING INDEX TABLESPACE dane_kadrowe;
--
ALTER TABLE klienci ADD CONSTRAINT klienci_uk1 UNIQUE (nazwisko, imie)
USING INDEX TABLESPACE dane_kadrowe;
--
CREATE TABLE adresy(
  id_adresu NUMBER,
  id_klienta NUMBER,
  ulica VARCHAR2(30),
  miasto VARCHAR2(30),
  region VARCHAR2(30))
TABLESPACE dane_kadrowe;
--
ALTER TABLE adresy ADD CONSTRAINT adres_fk1
FOREIGN KEY (id_klienta) REFERENCES klienci(id_klienta);
--
CREATE INDEX adres_fk1 ON adresy(id_klienta)
TABLESPACE dane_kadrowe;

create index klienci_idx2 on klienci(imie, nazwisko);
create bitmap index klienci_bmx1 on klienci(imie, nazwisko) invisible;

create index klienci_idx1 on klienci(imie) nosegment;

alter session set "_use_nosegment_indexes"=true;
set autotrace trace explain;
select imie from klienci where imie = 'WIKTORIA';
