SELECT
  'Segment Advice --------------------------'|| chr(10) ||
  'TABLESPACE_NAME  : ' || tablespace_name   || chr(10) ||
  'SEGMENT_OWNER    : ' || segment_owner     || chr(10) ||
  'SEGMENT_NAME     : ' || segment_name      || chr(10) ||
  'ALLOCATED_SPACE  : ' || allocated_space   || chr(10) ||
  'RECLAIMABLE_SPACE: ' || reclaimable_space || chr(10) ||
  'ZALECENIA        : ' || recommendations   || chr(10) ||
  'ROZWIAZANIE 1    : ' || c1                || chr(10) ||
  'ROZWIAZANIE 2    : ' || c2                || chr(10) ||
  'ROZWIAZANIE 3    : ' || c3 Porada
FROM
TABLE(dbms_space.asa_recommendations('FALSE', 'FALSE', 'FALSE'));

select segments_processed, end_time
from dba_auto_segadv_summary
order by end_time;

SELECT
  'Nazwa zadania     : ' || f.task_name || chr(10) ||
  'Czas uruchomienia : ' || TO_CHAR(execution_start, 'dd-mon-yy hh24:mi') || chr (10) ||
  'Nazwa segmentu    : ' || o.attr2     || chr(10) ||
  'Typ segmentu      : ' || o.type      || chr(10) ||
  'Nazwa partycji    : ' || o.attr3     || chr(10) ||
  'Komunikat         : ' || f.message   || chr(10) ||
  'Wicej informacji : ' || f.more_info || chr(10) ||
  '------------------------------------------------------' Porada
FROM
  dba_advisor_findings f,
  dba_advisor_objects o,
  dba_advisor_executions e
WHERE
  o.task_id = f.task_id
  AND o.object_id = f.object_id
  AND f.task_id = e.task_id
  AND e. execution_start > sysdate - 1
  AND e.advisor_name = 'Segment Advisor'
ORDER BY f.task_name;