/*
BasicExample2.java pokazuje jak uywa polece SQL typu przygotowane (prepared)
*/
// importuj pakiety JDBC
import java.sql.*;
class Product {
int productId;
int productTypeId;
String name;
String description;
double price;
}
public class BasicExample2 {
public static void main (String args []) {
try {
// zarejestruj sterowniki Oracle JDBC
DriverManager.registerDriver(
new oracle.jdbc.OracleDriver()
);
// DO EDYCJI - USTAWIENIA POCZENIA Z BAZ DANYCH
// utwrz obiekt Connection i podcz do bazy danych
// jako uzytkownik store z wykorzystaniem sterownika Oracle JDBC Thin
Connection myConnection = DriverManager.getConnection(
"jdbc:oracle:thin:@localhost:1521:ORCL",
"store",
"store_password"
);
// wycz tryb auto-commit
myConnection.setAutoCommit(false);
Product [] productArray = new Product[5];
for (int counter = 0; counter < productArray.length; counter ++) {
productArray[counter] = new Product();
productArray[counter].productId = counter + 13;
productArray[counter].productTypeId = 1;
productArray[counter].name = "Test product";
productArray[counter].description = "Test product";
productArray[counter].price = 19.95;
} // koniec ptli for
// utworz obiekt typu PreparedStatement
PreparedStatement myPrepStatement = myConnection.prepareStatement(
"INSERT INTO products " +
"(product_id, product_type_id, name, description, price) VALUES (" +
"?, ?, ?, ?, ?" +
")"
);
// zainicjuj wartoci dla nowych wierszy danych
// uywajc odpowiednich metod
for (int counter = 0; counter < productArray.length; counter ++) {
myPrepStatement.setInt(1, productArray[counter].productId);
myPrepStatement.setInt(2, productArray[counter].productTypeId);
myPrepStatement.setString(3, productArray[counter].name);
myPrepStatement.setString(4, productArray[counter].description);
myPrepStatement.setDouble(5, productArray[counter].price);
myPrepStatement.execute();
} // koniec ptli for
// zamknij obiekt typu PreparedStatement
myPrepStatement.close();
// otrzymaj kolumny product_id, product_type_id, name, description, i
// price dla tych nowych wierszy uywajc obiektu ResultSet
Statement myStatement = myConnection.createStatement();
ResultSet productResultSet = myStatement.executeQuery(
"SELECT product_id, product_type_id, " +
" name, description, price " +
"FROM products " +
"WHERE product_id > 12"
);
// wywietl wartoci kolumn
while (productResultSet.next()) {
System.out.println("product_id = " +
productResultSet.getInt("product_id"));
System.out.println("product_type_id = " +
productResultSet.getInt("product_type_id"));
System.out.println("name = " +
productResultSet.getString("name"));
System.out.println("description = " +
productResultSet.getString("description"));
System.out.println("price = " +
productResultSet.getDouble("price"));
} // koniec ptli while
// zamknij obiekt ResultSet uywajc metody close()
productResultSet.close();
// wycofaj transakcje z bazy danych
myConnection.rollback();
// zamknij inne obiekty JDBC
myStatement.close();
myConnection.close();
} catch (SQLException e) {
System.out.println("Error code = " + e.getErrorCode());
System.out.println("Error message = " + e.getMessage());
System.out.println("SQL state = " + e.getSQLState());
e.printStackTrace();
}
} // koniec funkcji main()
}
