-- The SQL*Plus script object_schema2.sql performs the following:
--   1. Creates object_user2
--   2. Creates the database object types
--   3. Populates the database tables with example data

-- This script should be run by the system user (or the DBA)
CONNECT system/manager;

-- drop object_user3
DROP USER object_user2 CASCADE;

-- create object_user3
CREATE USER object_user3 IDENTIFIED BY object_password;

-- allow object_user3 to connect and create database objects
GRANT connect, resource TO object_user3;

-- connect as object_user3
CONNECT object_user3/object_password;

-- tworzenie typw obiektowych
CREATE TYPE t_person AS OBJECT (
  id INTEGER,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  MEMBER FUNCTION display_details RETURN VARCHAR2
) NOT FINAL;
/

CREATE TYPE BODY t_person AS
  MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    RETURN 'id=' || id ||
      ', name=' || first_name || ' ' || last_name;
  END;
END;
/

CREATE TYPE t_business_person UNDER t_person (
  title VARCHAR2(20),
  company VARCHAR2(20),
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2
);

/
CREATE TYPE BODY t_business_person AS
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    -- uycie uoglnionego wywoania w celu wywoania display_details()
    -- z t_person
    RETURN (SELF AS t_person).display_details ||
      ', title=' || title || ', company=' || company;
   END;
END;
/

-- tworzenie tabeli
CREATE TABLE object_business_customers OF t_business_person;

-- wstawianie przykadowych wierszy
INSERT INTO object_business_customers VALUES (
  t_business_person(1, 'Jan', 'Brzowy', 'Kierownik', 'XYZ SA')
);



-- zatwierdza transakcj
COMMIT;
