/*
BasicExample1.java pokazuje jak:
- importowa pakiety JDBC
- adowa sterowniki Oracle JDBC
- podcza do bazy danych
- wykonywa rozkazy DML
- kontrolowa transakcje
- Uywa obiektw ResultSet do otrzymywania wierszy
- uywa metod get
- wykonywa rozkazy DDL
*/
// import pakietw JDBC
import java.sql.*;
public class BasicExample1 {
public static void main (String args []) {
// deklaracja obiektw Connection i Statement
Connection myConnection = null;
Statement myStatement = null;
try {
// rejestracja sterownikw Oracle JDBC
DriverManager.registerDriver(
new oracle.jdbc.OracleDriver()
);
// DO EDYCJI - USTAWIENIA POCZENIA Z BAZ DANYCH
// utwrz obiekt Connection I podcz do bazy danych
// jako uzytkownik store z wykorzystaniem sterownika Oracle JDBC Thin
myConnection = DriverManager.getConnection(
"jdbc:oracle:thin:@localhost:1521:ORCL",
"store",
"store_password"
);
// wycz tryb auto-commit
myConnection.setAutoCommit(false);
// utwrz obiekt Statement
myStatement = myConnection.createStatement();
// utwrz zmienne I obiekty uzywane do reprezentowania
// wartoci kolumn
int customerId = 6;
String firstName = "Jason";
String lastName = "Red";
java.sql.Date dob = java.sql.Date.valueOf("1969-02-22");
java.sql.Time dobTime;
java.sql.Timestamp dobTimestamp;
String phone = "800-555-1216";
// wykonaj polecenie INSERT aby doda nowy wiersz do
// tabeli customers uywajc wartoci ustawionych w powyszym
// kroku - metoda executeUpdate() klasy Statement
// obiekt jest wykorzystany do wykonania polecenia INSERT
myStatement.executeUpdate(
"INSERT INTO customers " +
"(customer_id, first_name, last_name, dob, phone) VALUES (" +
customerId + ", '" + firstName + "', '" + lastName + "', " +
"TO_DATE('" + dob + "', 'YYYY, MM, DD'), '" + phone + "')"
);
System.out.println("Added row to customers table");
// wykonaj polecenie UPDATE aby zmodyfikowa pole first_name
// gdzie customer_id wynosi 1
firstName = "Jean";
myStatement.executeUpdate(
"UPDATE customers " +
"SET first_name = '" + firstName + "' " +
"WHERE customer_id = 1"
);
System.out.println("Updated row in customers table");
// wykonaj polecenie DELETE aby usun klienta o identyfikatorze 5
myStatement.executeUpdate(
"DELETE FROM customers " +
"WHERE customer_id = 5"
);
System.out.println("Deleted row from customers table");
// utwrz obiekt ResultSet I wypenij go
// wynikiem polecenia SELECT ktre otrzymuje kolumny
// customer_id, first_name, last_name, dob i phone
// do otrzymania wszystkich wierszy z tabeli customers 
// zostaa wykorzystana metoda executeQuery() klasy Statement 

ResultSet customerResultSet = myStatement.executeQuery(
"SELECT customer_id, first_name, last_name, dob, phone " +
"FROM customers"
);
System.out.println("Retrieved rows from customers table");
// przemieszaj si po wierszach obiektu ResultSet uywajc
// metody next() i uyj metody get do odczytania wartoci
// otrzymanych z bazy danych
while (customerResultSet.next()) {
customerId = customerResultSet.getInt("customer_id");
firstName = customerResultSet.getString("first_name");
lastName = customerResultSet.getString("last_name");
dob = customerResultSet.getDate("dob");
dobTime = customerResultSet.getTime("dob");
dobTimestamp = customerResultSet.getTimestamp("dob");
phone = customerResultSet.getString("phone");
System.out.println("customerId = " + customerId);
System.out.println("firstName = " + firstName);
System.out.println("lastName = " + lastName);
System.out.println("dob = " + dob);
System.out.println("dobTime = " + dobTime);
System.out.println("dobTimestamp = " + dobTimestamp);
System.out.println("phone = " + phone);
} koniec ptli while
// zamknij obiekt ResultSet uywajc metody close()
customerResultSet.close();
// wycofaj zmiany dokonane w bazie danych
myConnection.rollback();
// utwrz zmienne numeryczne do przechowywania wartoci product_id and price 
short productIdShort;
int productIdInt;
long productIdLong;
float priceFloat;
double priceDouble;
java.math.BigDecimal priceBigDec;
// utwrz inny obiekt ResultSet i otrzymaj
// product_id, product_type_id, i price dla produktu o identyf. 12
// (ten wiersz ma warto NULL w kolumnie product_type_id )
ResultSet productResultSet = myStatement.executeQuery(
"SELECT product_id, product_type_id, price " +
"FROM products " +
"WHERE product_id = 12"
);
System.out.println("Retrieved row from products table");
while (productResultSet.next()) {
System.out.println("product_id = " +
productResultSet.getInt("product_id"));
System.out.println("product_type_id = " +
productResultSet.getInt("product_type_id"));
// sprawd czy wasnie odczytana warto przez metod get wynosia NULL
if (productResultSet.wasNull()) {
System.out.println("Last value read was NULL");
}
// uyj metody getObject() by odczyta warto, skonwertuj j
// do obiektu klasy opakowujcej  polecenie konwertuje warto NULL z bazy
// do wartoci null Javy
java.lang.Integer productTypeId =
(java.lang.Integer) productResultSet.getObject("product_type_id");
System.out.println("productTypeId = " + productTypeId);
// retrieve the product_id and price column values into
// the various numeric variables created earlier
productIdShort = productResultSet.getShort("product_id");
productIdInt = productResultSet.getInt("product_id");
productIdLong = productResultSet.getLong("product_id");
priceFloat = productResultSet.getFloat("price");
priceDouble = productResultSet.getDouble("price");
priceBigDec = productResultSet.getBigDecimal("price");
System.out.println("productIdShort = " + productIdShort);
System.out.println("productIdInt = " + productIdInt);
System.out.println("productIdLong = " + productIdLong);
System.out.println("priceFloat = " + priceFloat);
System.out.println("priceDouble = " + priceDouble);
System.out.println("priceBigDec = " + priceBigDec);
} // koniec ptli while
// zamknij obiekt ResultSet
productResultSet.close();
// wykonaj polecenie DDL CREATE TABLE aby utworzy nowa tabel
// bdzie w niej mona przechowywa adresy klientw
myStatement.execute(
"CREATE TABLE addresses (" +
" address_id INTEGER CONSTRAINT addresses_pk PRIMARY KEY," +
" customer_id INTEGER CONSTRAINT addresses_fk_customers " +
" REFERENCES customers(customer_id)," +
" street VARCHAR2(20) NOT NULL," +
" city VARCHAR2(20) NOT NULL," +
" state CHAR(2) NOT NULL" +
")"
);
System.out.println("Created addresses table");
// usu tabel uywajc polecenia DROP TABLE
myStatement.execute("DROP TABLE addresses");
System.out.println("Dropped addresses table");
} catch (SQLException e) {
System.out.println("Error code = " + e.getErrorCode());
System.out.println("Error message = " + e.getMessage());
System.out.println("SQL state = " + e.getSQLState());
e.printStackTrace();
} finally {
try {
// zakocz obiekt klasy Statement uywajc metody close()
if (myStatement != null) {
myStatement.close();
}
// zakocz obiekt Connection uywajc metody close()
if (myConnection != null) {
myConnection.close();
}
} catch (SQLException e) {
e.printStackTrace();
}
}
} // koniec funkcji main()
}
