create table sekretne_dane (id number primary key,
  opis varchar2(30),
  ostatnio_mod_przez number );

create table kto_zmienial_sekretne_dane (id number,
  data_zmiany date,
  id_uzytkownika number );

alter table kto_zmienial_sekretne_dane add constraint pk_kzsd primary key (id, data_zmiany);



CREATE OR REPLACE TRIGGER ctr_audit_sekretne_dane
FOR INSERT OR UPDATE ON sekretne_dane
COMPOUND TRIGGER
-- początek sekcji wstępnej
-- deklaracje
  prog CONSTANT SIMPLE_INTEGER := 10;
  TYPE sekretne_dane_t IS TABLE OF kto_zmienial_sekretne_dane%rowtype INDEX BY PLS_INTEGER;
  v_sekretne_dane sekretne_dane_t;
  idx SIMPLE_INTEGER:=0;
-- podprogram
PROCEDURE Oproznienie_sekretnej_tablicy IS
  n CONSTANT SIMPLE_INTEGER := v_sekretne_dane.Count();
BEGIN
  FORALL j IN 1..n
    INSERT INTO kto_zmienial_sekretne_dane VALUES v_sekretne_dane (j);
  v_sekretne_dane.Delete();
  idx := 0;
END Oproznienie_sekretnej_tablicy;

-- koniec sekcji wstępnej
-- sekcja opcjonalna
BEFORE STATEMENT IS
BEGIN
  v_sekretne_dane.Delete();
  idx := 0;
END BEFORE STATEMENT;

AFTER EACH ROW IS
BEGIN
  idx := idx + 1;
  v_sekretne_dane(idx).ID:= :New.ID;
  v_sekretne_dane(idx).data_zmiany := SYSDATE();
  v_sekretne_dane(idx).id_uzytkownika := :New.ostatnio_mod_przez;
  IF idx >= prog THEN
    Oproznienie_sekretnej_tablicy();
  END IF;
END AFTER EACH ROW;

AFTER STATEMENT IS
BEGIN
  Oproznienie_sekretnej_tablicy();
END AFTER STATEMENT;

END ctr_audit_sekretne_dane;
/

