/*
 * Run.sql
 * Rozdzia 17, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt testuje procedur DBMS_JOB.RUN
 */

SET VERIFY OFF
SET VERIFY OFF
UNDEFINE job_number

exec CLEAN_SCHEMA.jobs
exec CLEAN_SCHEMA.procs
exec CLEAN_SCHEMA.tables

PROMPT
PROMPT Tabela email_tbl do przechowywania szczegolow dotyczacych listow
PROMPT

CREATE TABLE email_tbl (
	EMAILID NUMBER(10) 
	      CONSTRAINT emailid_pk PRIMARY KEY,
	SENDER VARCHAR2(100 CHAR) 
	      NOT NULL,
	RECIPIENTS VARCHAR2(4000 CHAR) 
	      NOT NULL,
	CC VARCHAR2(4000),
	BCC VARCHAR2(4000),
	SUBJECT VARCHAR2(50),
	MESSAGE VARCHAR2(4000),
	ATTACHMENT VARCHAR2(4000),
	DATE_LOGGED TIMESTAMP DEFAULT SYSTIMESTAMP,
	DATE_SENT TIMESTAMP);

PROMPT
PROMPT Szesc przykladowych listow elektronicznych -- jesli chcesz odebrac poczte, zmodyfikuj kod
PROMPT

INSERT INTO email_tbl
   VALUES (1, 'email1@myemail.com', 'email1@youremail.com', 
           'email1@someonesemail.com', 'email1@theotheremail.com',
           'Temat 1', 'Wiadomosc z listu numer 1',
           'To zalacznik wewnatrzwierszowy numer 1', null, null);

INSERT INTO email_tbl
   VALUES (2, 'email2@myemail.com', 'email2@youremail.com',
           'email2@someonesemail.com', 'email2@theotheremail.com',
           'Temat 2', 'Wiadomosc z listu numer 2',
           'To zalacznik wewnatrzwierszowy numer 2', null, null);

INSERT INTO email_tbl
   VALUES (3, 'email3@myemail.com', 'email3@youremail.com',
           'email3@someonesemail.com', 'email3@theotheremail.com',
           'Temat 3', 'Wiadomosc z listu numer 3',
           'To zalacznik wewnatrzwierszowy numer 3', null, null);

INSERT INTO email_tbl
   VALUES (4, 'email4@myemail.com', 'email4@youremail.com',
           'email4@someonesemail.com', 'email4@theotheremail.com',
           'Temat 4', 'Wiadomosc z listu numer 4',
           'To zalacznik wewnatrzwierszowy numer 4', null, null);


INSERT INTO email_tbl
   VALUES (5, 'email5@myemail.com', 'email5@youremail.com',
           'email5@someonesemail.com', 'email5@theotheremail.com',
           'Temat 5', 'Wiadomosc z listu numer 5',
           'To zalacznik wewnatrzwierszowy numer 5', null, null);


INSERT INTO email_tbl
   VALUES (6, 'email6@myemail.com', 'email6@youremail.com',
           'email6@someonesemail.com', 'email6@theotheremail.com',
           'Temat 6', 'Wiadomosc z listu numer 6',
           'To zalacznik wewnatrzwierszowy numer 6', null, null);

COMMIT;

PROMPT 
PROMPT Pakiet email_manager do wysylania listow elektronicznych
PROMPT

CREATE OR REPLACE PACKAGE email_manager
IS

   PROCEDURE smtp (i_host_string VARCHAR2);
   PROCEDURE inline_email;

END;
/



CREATE OR REPLACE PACKAGE BODY email_manager
IS

PROCEDURE smtp (i_host_string VARCHAR2)
AS

   v_host_string VARCHAR2(500) :=
                      i_host_string;
   v_conn_string UTL_SMTP.CONNECTION;

   CURSOR email_cur
   IS
   SELECT *
   FROM email_tbl
   WHERE DATE_SENT IS NULL;

BEGIN
   
   FOR y IN email_cur
   LOOP
      UTL_SMTP.HELO(v_conn_string, v_host_string);
      UTL_SMTP.MAIL(v_conn_string, y.sender);
      UTL_SMTP.RCPT(v_conn_string, y.recipients);
      UTL_SMTP.OPEN_DATA(v_conn_string);
      UTL_SMTP.WRITE_DATA(v_conn_string, y.message);
      UTL_SMTP.CLOSE_DATA(v_conn_string);
      UTL_SMTP.QUIT(v_conn_string);

      UPDATE email_tbl
      SET date_sent = systimestamp
      WHERE emailid = y.emailid;
   END LOOP;

   COMMIT;

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END smtp;

PROCEDURE inline_email
AS

   CURSOR email_cur
   IS
   SELECT * 
   FROM email_tbl
   WHERE DATE_SENT IS NULL;

BEGIN

   FOR y IN email_cur
   LOOP
      UTL_MAIL.SEND_ATTACH_VARCHAR2 (
         SENDER => y.sender,
         RECIPIENTS => y.recipients,
         CC => y.cc,
         BCC => y.bcc,
         SUBJECT => y.subject,
         MESSAGE => y.message,
         ATTACHMENT => y.attachment,
         ATT_INLINE => TRUE);

      UPDATE email_tbl
      SET date_sent = systimestamp
      WHERE emailid = y.emailid;
   END LOOP;

   COMMIT;

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END inline_email;

END;
/

PROMPT
PROMPT Ta procedura pobiera informacje o zadaniach
PROMPT

CREATE OR REPLACE PROCEDURE get_job_details(
   i_job_number IN NUMBER,
   cv_job_details IN OUT SYS_REFCURSOR)
IS
BEGIN
   OPEN cv_job_details FOR
   SELECT job, schema_user schema, 
          to_char(next_date, 'dd-mon-yyyy hh24:mi:ss') NEXT_DATE, 
          interval, what, broken
   FROM user_jobs
   WHERE job = i_job_number;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END get_job_details;
/

PROMPT
PROMPT Liczba rekordow w tabeli EMAIL_TBL
PROMPT

SELECT count(1)
FROM email_tbl;

PROMPT
PROMPT Numery zadan
PROMPT

COL what FORMAT A40
SELECT job, what
FROM user_jobs;

PROMPT
PROMPT Przyklad zastosowania procedury DBMS_JOB.RUN
PROMPT

DECLARE
   v_error EXCEPTION;

   PRAGMA EXCEPTION_INIT(v_error, -23421);

BEGIN

   DBMS_JOB.RUN(job => &&job_number, FORCE => TRUE);
   COMMIT;
EXCEPTION
   WHEN v_error
   THEN
      DBMS_OUTPUT.PUT_LINE('Wpisany numer zadania jest nieprawidlowy');

END;
/

SET PAGES 9999

SELECT *
FROM dba_jobs_running
WHERE job = &&job_number;


PROMPT
PROMPT Sprawdzanie widoku USER_JOBS
PROMPT

VARIABLE v_job_details REFCURSOR
EXEC GET_JOB_DETAILS(&&job_number, :v_job_details)

COL schema_user FORMAT A15
COL next_date FORMAT A20
COL interval FORMAT A60
COL what FORMAT A4000
SET PAGES 9999
PRINT v_job_details

PROMPT
PROMPT Liczba rekordow w tabeli EMAIL_TBL
PROMPT

SELECT count(1)
FROM email_tbl;
