/*
 * TextIndex.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje indeksowanie za pomoc Oracle Text
 */

exec CLEAN_SCHEMA.TABLES
exec CLEAN_SCHEMA.OBJECTS
exec CLEAN_SCHEMA.PROCS
exec CLEAN_SCHEMA.IND

CREATE TABLE book_samples (
   book_sample_id   NUMBER (10) PRIMARY KEY,
   isbn             CHAR(10 CHAR),
   description      CLOB,
   nls_description  NCLOB,
   book_cover       BLOB,
   chapter_title    VARCHAR2(30 CHAR),
   chapter          BFILE
)  
   LOB (book_cover) 
      STORE AS blob_seg ( TABLESPACE blob_ts
                 CHUNK 8192
                 PCTVERSION 0
                 NOCACHE
                 NOLOGGING
                 DISABLE STORAGE IN ROW)
   LOB (description, nls_description) 
   STORE AS ( TABLESPACE clob_ts
                 CHUNK 8192
                 PCTVERSION 10
                 NOCACHE
                 LOGGING
                 ENABLE STORAGE IN ROW);

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   1,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej.',
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', '72230665.jpg'));

commit;

PROMPT
PROMPT ** Create the CONTEXT index on the description column
PROMPT

-- Jeli chcesz zastosowa indeksowanie tematyczne w Oracle 10gR1, pamitaj, e
--  pojedyncza instalacyjna pyta cd nie obejmuje bazy wiedzy.  Trzeba zainstalowa take
--  pyt z narzdziami pomocnicznymi. Zapoznaj si z uwag 262701.1 na witrynie http://metalink.oracle.com

BEGIN
   ctx_ddl.create_preference ('lob_lexer', 'basic_lexer');
   ctx_ddl.set_attribute ('lob_lexer', 'index_text', 'true');
   ctx_ddl.set_attribute ('lob_lexer', 'index_themes', 'false');
END;
/

BEGIN
   ctx_ddl.create_preference ('lob_wordlist', 'basic_wordlist');
   ctx_ddl.set_attribute ('lob_wordlist', 'substring_index', 'true');
END;
/

-- Tworzenie indeksu przy uyciu pustej listy nieindeksowanych elementw
CREATE INDEX lob_indx ON book_samples(description)
INDEXTYPE IS CTXSYS.CONTEXT
PARAMETERS ( 'lexer lob_lexer 
              wordlist lob_wordlist 
              stoplist ctxsys.empty_stoplist' );

set pages 9999
SELECT token_text
FROM DR$LOB_INDX$I;

DROP INDEX lob_indx force;

-- Utworzenie indeksu przy uyciu domylnej listy nieindeksowanych elementw
CREATE INDEX lob_indx ON book_samples(description)
INDEXTYPE IS CTXSYS.CONTEXT
PARAMETERS ( 'lexer lob_lexer 
              wordlist lob_wordlist 
              stoplist ctxsys.default_stoplist' );

set pages 9999
SELECT token_text
FROM DR$LOB_INDX$I;

SELECT SCORE(1), book_sample_id
FROM book_samples
WHERE CONTAINS(description, 'witrynie', 1) > 0;
