/*
 * BfileClose.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt testuje procedur DBMS_LOB.CLOSE
 */

exec CLEAN_SCHEMA.TABLES
exec CLEAN_SCHEMA.OBJECTS
exec CLEAN_SCHEMA.PROCS

PROMPT
PROMPT ** Tworzenie tabeli book_samples
PROMPT

CREATE TABLE book_samples (
   book_sample_id     NUMBER (10) PRIMARY KEY,
   isbn               CHAR(10 CHAR),
   description        CLOB,
   nls_description    NCLOB,
   misc               BLOB,
   chapter_title      VARCHAR2(30 CHAR),
   bfile_description  BFILE
)  
   LOB (misc) 
      STORE AS blob_seg ( TABLESPACE blob_ts
                 CHUNK 8192
                 PCTVERSION 0
                 NOCACHE
                 NOLOGGING
                 DISABLE STORAGE IN ROW)
   LOB (description, nls_description) 
   STORE AS ( TABLESPACE clob_ts
                 CHUNK 8192
                 PCTVERSION 10
                 NOCACHE
                 LOGGING
                 ENABLE STORAGE IN ROW);

PROMPT
PROMPT ** Wstawianie dwoch rekordow do tabeli book_samples
PROMPT

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   misc,
   bfile_description)
 VALUES (
   1,
   '72230665', 
   EMPTY_CLOB(),
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', 'bfile_example.pdf'));

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   misc,
   bfile_description)
 VALUES (
   2,
   '72230665', 
   EMPTY_CLOB(),
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', 'bfile_example2.pdf'));

COMMIT;

PROMPT
PROMPT ** Tworzenie procedury CLOSE_FILE
PROMPT

SET SERVEROUTPUT ON

CREATE OR REPLACE PROCEDURE CLOSE_FILE (
   v_bfile IN OUT BFILE)
AS
   v_isopen PLS_INTEGER := 0;
BEGIN

   DBMS_OUTPUT.PUT_LINE('Sprawdzanie, czy plik jest otworzony');
   DBMS_OUTPUT.PUT_LINE('====================================');
   DBMS_LOB.OPEN(v_bfile);
   v_isopen := DBMS_LOB.ISOPEN(v_bfile);

   IF v_isopen = 0
   THEN
      DBMS_OUTPUT.PUT_LINE ('Plik jest zamknity.');
   ELSE
      DBMS_OUTPUT.PUT_LINE ('Plik jest otworzony.');
   END IF;

   DBMS_OUTPUT.PUT_LINE ('====================================');
   DBMS_OUTPUT.PUT_LINE ('Sprawdzanie, czy plik jest zamkniety');
   DBMS_OUTPUT.PUT_LINE ('====================================');

   DBMS_LOB.CLOSE(v_bfile);

   v_isopen := DBMS_LOB.ISOPEN(v_bfile);

   IF v_isopen = 0
   THEN
      DBMS_OUTPUT.PUT_LINE ('Plik jest zamkniety.');
   ELSE
      DBMS_OUTPUT.PUT_LINE ('Plik jest otworzony.');
   END IF;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE (SQLERRM);
END;
/


PROMPT
PROMPT ** Sprawdzanie, czy plik jest otworzony
PROMPT


DECLARE
   v_bfile BFILE;
BEGIN
   SELECT bfile_description
   INTO v_bfile
   FROM book_samples
   WHERE book_sample_id = 1;

   CLOSE_FILE(v_bfile);
END;
/
