/*
 * DynamicDispatch.sql
 * Rozdzia 14, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dynamiczne wyszukiwanie (polimorfizm dynamiczny)
 */

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

CREATE OR REPLACE TYPE abbrev_inventory_obj AS OBJECT (
   item_id   NUMBER (10),
   price     NUMBER (10, 2),
   MEMBER PROCEDURE print_price
)
NOT FINAL INSTANTIABLE;
/

CREATE OR REPLACE TYPE BODY abbrev_inventory_obj
AS
   MEMBER PROCEDURE print_price
   IS
      v_price   NUMBER := SELF.price * .80;
   BEGIN
      DBMS_OUTPUT.put_line ('Cena hurtowa: ' || v_price);
   END print_price;
END;
/

CREATE OR REPLACE TYPE abbrev_book_obj
UNDER abbrev_inventory_obj (
   isbn   VARCHAR2 (50),
   OVERRIDING MEMBER PROCEDURE print_price
)
FINAL INSTANTIABLE;
/

CREATE OR REPLACE TYPE BODY abbrev_book_obj
AS
   OVERRIDING MEMBER PROCEDURE print_price
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('Cena detaliczna: ' || SELF.price);
   END print_price;
END;
/

/*******************************************************
* 
* SET SERVEROUTPUT ON SIZE 1000000
* DECLARE
*    v_wholesale   abbrev_inventory_obj := abbrev_inventory_obj (22, 54.95);
*    v_retail      abbrev_book_obj     := abbrev_book_obj (22, 54.95, 23022843);
* BEGIN
*    DBMS_OUTPUT.put_line ('TYP POCHODNY - CENA WYJCIOWA');
*    DBMS_OUTPUT.put_line ('=============================');
*    v_retail.print_price;
*    DBMS_OUTPUT.put_line ('	');
*    DBMS_OUTPUT.put_line ('TYP BAZOWY - OBNIONA CENA');
*    DBMS_OUTPUT.put_line ('==========================');
*    v_wholesale.print_price;
*    DBMS_OUTPUT.put_line ('	');
*    DBMS_OUTPUT.put_line ('DYNAMICZNE WYSZUKIWANIE');
*    DBMS_OUTPUT.put_line (''METODA TYPU POCHODNEGO URUCHAMIANA DLA TYPU BAZOWEGO');
*    DBMS_OUTPUT.put_line ('=====================================================');
*    v_wholesale := v_retail;
*    v_wholesale.print_price;
* END;
* /
* 
*******************************************************/
