/*
 * next_item_type1.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt testuje obsug potokw prywatnych przy uyciu pakietu DBMS_PIPE
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Gwarantowanie utworzenia potoku publicznego
@create_pipe2.sql

-- Demonstruje przesyanie komunikatw
DECLARE

  -- Definicja zmiennej session
  session     VARCHAR2(30) := DBMS_PIPE.UNIQUE_SESSION_NAME;

  -- Definicja przeamania wiersza do rozdzielania odrbnych zapisw do potoku 
  line_return VARCHAR2(1) := CHR(10);
  message     VARCHAR2(4000);
  output      VARCHAR2(4000);

  -- Definicje zmiennych na zwracane wartoci
  flag        INTEGER;
  code        INTEGER;

  -- Definicje i deklaracje zmiennych wejciowych
  message1    INTEGER     := 1776;
  message2    DATE        := TO_DATE('04-LIP-1776');
  message3    VARCHAR2(30 CHAR) := 'Jan Kowalski';

  -- Definicje zmiennych wyjciowych
  message11   INTEGER;
  message12   DATE;
  message13   VARCHAR2(30 CHAR);

BEGIN

  -- Usunicie zawartoci potoku
  DBMS_PIPE.PURGE('PLSQL$MESSAGE_INBOX');

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Komunikat wejsciowy potoku');
  DBMS_OUTPUT.PUT_LINE('Sesja: ['||session||']');
  DBMS_OUTPUT.PUT_LINE('-------------------------------');

  -- Naley wykona ponisze operacje na message1, message2 and message3:
  -- 1. Wywietli wiersz wejciowy.
  -- 2. Uy odpowiedniej procedury do umieszczenia komunikatu w buforze lokalnym
  --    dla okrelonego typu danych 
  -- 3. Wysa komunikat; zwrcone zero oznacza powodzenie

  -- Operacje na message1
  DBMS_OUTPUT.PUT_LINE(message1||'[NUMBER]');
  DBMS_PIPE.PACK_MESSAGE(message1);
  flag := DBMS_PIPE.SEND_MESSAGE('PLSQL$MESSAGE_INBOX');

  -- Operacje na message2
  DBMS_OUTPUT.PUT_LINE(message2||'[DATE]');
  DBMS_PIPE.PACK_MESSAGE(message2);
  flag := DBMS_PIPE.SEND_MESSAGE('PLSQL$MESSAGE_INBOX');

  -- Operacje na message3
  DBMS_OUTPUT.PUT_LINE(message3||'[VARCHAR2]');
  DBMS_PIPE.PACK_MESSAGE(message3);
  flag := DBMS_PIPE.SEND_MESSAGE('PLSQL$MESSAGE_INBOX');

  -- Wywietlenie komunikatu na podstawie wartoci zmiennej flag
  IF (flag = 0) THEN
    DBMS_OUTPUT.PUT_LINE('Przeslano komunikat do PLSQL$MESSAGE_INBOX.');
  END IF;

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT(line_return);
  DBMS_OUTPUT.PUT_LINE('Komunikat wyjsciowy z potoku');
  DBMS_OUTPUT.PUT_LINE('Sesja: ['||session||']');
  DBMS_OUTPUT.PUT_LINE('----------------------------');

  -- Uywa ptli for bazujcej na przedziale do pobrania i odczytania trzech komunikatw 
  FOR i IN 1..3 LOOP

    -- Zerowanie bufora lokalnego
    DBMS_PIPE.RESET_BUFFER;

    -- Pobieranie komunikatu; zwrcona warto zero oznacza powodzenie
    flag := DBMS_PIPE.RECEIVE_MESSAGE('PLSQL$MESSAGE_INBOX',0);

    -- Pobiera typ elementu z zawartoci bufora
    code := DBMS_PIPE.NEXT_ITEM_TYPE;    

    -- Instrukcja CASE suy do zwracania acuchw znakw 
    CASE code

      -- Jeli zawarto bufora ma typ NUMBER
      WHEN 6 THEN

        -- Rozpakowanie do zmiennej typu NUMBER
        DBMS_PIPE.UNPACK_MESSAGE(message11);
        output := output || message11
               ||'[NUMBER]'||line_return;

      -- Jeli zawarto bufora ma typ VARCHAR2
      WHEN 9 THEN

        -- Rozpakowanie do zmiennej typu VARCHAR2
        DBMS_PIPE.UNPACK_MESSAGE(message13);
        output := output || message13
               ||'[VARCHAR2]'||line_return;

      -- Jeli zawarto bufora ma typ DATE
      WHEN 12 THEN

        -- Rozpakowanie do zmiennej typu DATE
        DBMS_PIPE.UNPACK_MESSAGE(message12);
        output := output || message12
               ||'[DATE]'||line_return;

    END CASE;

  END LOOP;

  -- Wywietlanie komunikatu na podstawie wartoci zmiennej flag
  IF (flag = 0) THEN

    -- Wywietlanie zmiennej wyjciowej
    DBMS_OUTPUT.PUT(output);

    -- Wywietlanie potwierdzenia
    DBMS_OUTPUT.PUT_LINE(
      'Pobrano komunikat z PLSQL$MESSAGE_INBOX.');

  END IF;

END;
/
