/*
 * create_user.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt sprawdza i definiuje uytkownika plsql.
 *   Trzeba uruchomi ten skrypt z konta SYSTEM lub z konta
 *   z uprawnieniami roli DBA i uprawnieniami EXECUTE
 *   do pakietu DBMS_PIPE z moliwoci ich przyznawania.
 */

-- Odznacz komentarz na potrzeby diagnozowania
-- SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja wyjtku
  wrong_schema EXCEPTION;
  PRAGMA EXCEPTION_INIT(wrong_schema,-20001);

  -- Definicja zwracanej wartoci
  retval VARCHAR2(1 CHAR);

  /*
  || Definicja kursora do sprawdzania, czy biecy uytkownik to
  || SYSTEM lub uytkownik z uprawnieniami roli DBA
  */
  CURSOR privs IS
    SELECT   DISTINCT null
    FROM     user_role_privs
    WHERE    username = 'SYSTEM'
    OR       granted_role = 'DBA';

BEGIN

  -- Otwarcie kursora i wczytywanie z niego danych
  OPEN privs;
  LOOP

    -- Wczytanie wiersza
    FETCH privs INTO retval;

    -- Sprawdzenie, czy kursor nie zawid
    IF privs%NOTFOUND THEN

      -- Zgoszenie wyjtku
      RAISE wrong_schema;

    ELSE

      -- Sprawdzanie, czy uytkownik PLSQL istnieje i usuwanie go
      FOR i IN (SELECT null FROM dba_users WHERE username = 'PLSQL') LOOP
        EXECUTE IMMEDIATE 'DROP USER plsql CASCADE';
      END LOOP;

      -- Utworzenie uytkownika i nadanie mu uprawnie
      EXECUTE IMMEDIATE 'CREATE USER plsql IDENTIFIED BY plsql';
      EXECUTE IMMEDIATE 'GRANT connect TO plsql';
      EXECUTE IMMEDIATE 'GRANT resource TO plsql';
      EXECUTE IMMEDIATE 'GRANT execute ON dbms_pipe TO plsql';
      EXECUTE IMMEDIATE 'GRANT execute ON dbms_alert TO plsql';

      -- Wywietlenie komunikatu o powodzeniu
      DBMS_OUTPUT.PUT_LINE(CHR(10)||'Utworzono uzytkownika PLSQL.');

    END IF; 

    -- Wyjcie z ptli
    EXIT;

  END LOOP;

  -- Zamknicie kursora
  CLOSE privs;

EXCEPTION

  -- Obsuga zdefiniowanego wyjtku
  WHEN wrong_schema THEN
    DBMS_OUTPUT.PUT_LINE('Ten skrypt musi zosta wykonany z konta SYSTEM i '
    ||                   'przy uyciu schematu <'||user||'> lub '
    ||                   'z konta z uprawnieniami roli DBA.');

  -- Oglna obsuga wyjtkw
  WHEN others THEN
    DBMS_OUTPUT.PUT_LINE(SQLERRM);
    RETURN;

END;
/

-- Formatowanie SQL*Plus
COL grantee          FORMAT A8
COL granted_role     FORMAT A30
COL grantor          FORMAT A8
COL privilege        FORMAT A12
COL owner            FORMAT A4
COL table_name       FORMAT A30

-- Sprawdzanie rl uytkownika
SELECT   grantee
,        granted_role
FROM     dba_role_privs
WHERE    grantee = 'PLSQL';

-- Zapytanie o zasoby
SELECT   grantor
,        owner
,        table_name
,        grantee
,        privilege
FROM     dba_tab_privs
WHERE    grantee = 'PLSQL';
