/*
 * insteadOf2.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wyzwalacze zdefiniowane przez uytkownika
 */

SET ECHO ON

-- Przy uyciu tego wyzwalacza mona obsuy proste wstawianie danych.
-- Warto zauway, e uwzgldniany jest tyklo jeden przypadek, a kod nie obejmuje
-- obsugi bdw
CREATE OR REPLACE TRIGGER InsertBooksAuthors
  INSTEAD OF INSERT ON books_authors
DECLARE

  v_Book books%ROWTYPE;
  v_AuthorID authors.id%TYPE;

BEGIN
  -- Sprawdzanie identyfikatora nowego autora
  BEGIN
    SELECT id
      INTO v_AuthorID
      FROM authors
      WHERE first_name = :new.first_name
        AND last_name = :new.last_name;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      -- Nie znaleziono autora - naley utworzy nowego
      INSERT INTO authors (id, first_name, last_name)
        VALUES (author_sequence.NEXTVAL, :new.first_name, :new.last_name)
        RETURNING ID INTO v_AuthorID;
  END;
  
  SELECT *
    INTO v_Book
    FROM books
    WHERE isbn = :new.isbn;
    
  -- Sprawdzanie, czy ksika ma ju jednego lub dwch autorw,
  -- i aktualizowanie danych
  IF v_Book.author2 IS NULL THEN
    UPDATE books
      SET author2 = v_AuthorID
      WHERE isbn = :new.isbn;
  ELSE
    UPDATE books
      SET author3 = v_AuthorID
      WHERE isbn = :new.isbn;
  END IF;
END InsertBooksAuthors;
/
show errors

-- Teraz wykonanie instrukcji INSERT powinno si powie
INSERT INTO books_authors (isbn, title, first_name, last_name)
  VALUES ('72230665', 'Oracle Database 10g PL/SQL Programming',
          'Joe', 'Blow');
          
