/*
 * createNonMutating.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje pakiet i wyzwalacze zdefiniowane przez uytkownika
 */

SET ECHO ON

CREATE OR REPLACE PACKAGE StudentData AS
  TYPE t_Majors IS TABLE OF students.major%TYPE
    INDEX BY BINARY_INTEGER;
  TYPE t_IDs IS TABLE OF students.ID%TYPE
    INDEX BY BINARY_INTEGER;

  v_StudentMajors t_Majors;
  v_StudentIDs    t_IDs;
  v_NumEntries    BINARY_INTEGER := 0;
END StudentData;
/
show errors

CREATE OR REPLACE TRIGGER RLimitMajors
  BEFORE INSERT OR UPDATE OF major ON students
  FOR EACH ROW
BEGIN
  /* Rejestruje dane w pakiecie StudentData. Nie wprowadza adnych zmian w
     tabeli students, co pozwala unikn bdu ORA-4091 */
  StudentData.v_NumEntries := StudentData.v_NumEntries + 1;
  StudentData.v_StudentMajors(StudentData.v_NumEntries) := 
    :new.major;
  StudentData.v_StudentIDs(StudentData.v_NumEntries) := :new.id;
END RLimitMajors;
/

CREATE OR REPLACE TRIGGER SLimitMajors
  AFTER INSERT OR UPDATE OF major ON students
DECLARE
  v_MaxStudents     CONSTANT NUMBER := 2;
  v_CurrentStudents NUMBER;
  v_StudentID       students.ID%TYPE;
  v_Major           students.major%TYPE;
BEGIN
  /* Przejcie w ptli po wszystkich wstawionych lub zaktualizowanych studentach
     i sprawdzenie, czy nie przekroczono limitu */
  FOR v_LoopIndex IN 1..StudentData.v_NumEntries LOOP
    v_StudentID := StudentData.v_StudentIDs(v_LoopIndex);
    v_Major := StudentData.v_StudentMajors(v_LoopIndex);

    -- Sprawdzanie aktualnej liczby studentw na specjalizacji
    SELECT COUNT(*)
      INTO v_CurrentStudents
      FROM students
      WHERE major = v_Major;

    -- Jeli nie ma miejsc, naley zgosi bd
    IF v_CurrentStudents > v_MaxStudents THEN
      RAISE_APPLICATION_ERROR(-20000, 
        'Zbyt wielu studentow na specjalizacji ' || v_Major ||
        ' z powodu studenta ' || v_StudentID);
    END IF;
  END LOOP;

  -- Wyzerowanie licznika, aby przy nastpnym wykonaniu uy nowych danych
  StudentData.v_NumEntries := 0;
END SLimitMajors;
/
