/*
 * cascadeRSInsert.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wyzwalacze zdefiniowane przez uytkownika
 */

SET ECHO ON

CREATE OR REPLACE TRIGGER CascadeRSInserts
  /* Zapewnia synchronizacj tabel registered_students, students i classes
     po wywoaniu instrukcji INSERT na tabeli registered_students */
  BEFORE INSERT ON registered_students
  FOR EACH ROW
DECLARE
  v_Credits classes.num_credits%TYPE;
BEGIN
  -- Okrela liczb punktw za dany kurs
  SELECT num_credits
    INTO v_Credits
    FROM classes
    WHERE department = :new.department
    AND course = :new.course;

  -- Zmienia biec ilo punktw danego studenta
  UPDATE students
    SET current_credits = current_credits + v_Credits
    WHERE ID = :new.student_id;

  -- Dodaje jeden do liczby studentw na kursie
  UPDATE classes
    SET current_students = current_students + 1
    WHERE department = :new.department
    AND course = :new.course;
END CascadeRSInserts;
/
