/*
 * GenerateAuthorID.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowania identyfikatora :new w wyzwalaczu
 */

SET ECHO ON

CREATE OR REPLACE TRIGGER GenerateAuthorID
  BEFORE INSERT OR UPDATE ON authors
  FOR EACH ROW
BEGIN
  /* Zapenia pole ID tabeli authors nastpn wartoci z tablicy
     author_sequence. Poniewa ID to kolumna tabeli authors, :new.ID
     to poprawne odwoanie */
  SELECT author_sequence.NEXTVAL
    INTO :new.ID
    FROM dual;
END GenerateAuthorID;
/
show errors

-- Obie ponisze instrukcje INSERT bd uyway sekwencji kolumny ID
INSERT INTO authors (first_name, last_name)
  VALUES ('Lolita', 'Lazarus');
INSERT INTO authors (ID, first_name, last_name)
  VALUES (-7, 'Zelda', 'Zoom');

-- Ta wersja wyzwalacza uywa klauzuli REFERENCING
CREATE OR REPLACE TRIGGER GenerateAuthorID
  BEFORE INSERT OR UPDATE ON authors
  REFERENCING new AS new_author
  FOR EACH ROW
BEGIN
  /* Zapenia pole ID tabeli authors nastpn wartoci z tablicy
     author_sequence. Poniewa ID to kolumna tabeli authors, :new.ID
     to poprawne odwoanie */
  SELECT author_sequence.NEXTVAL
    INTO :new_author.ID
    FROM dual;
END GenerateAuthorID;
/
show errors
