/*
 * remoteDependencies.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zalenoci midzy obiektami z rnych
 * baz danych
 */

set serveroutput on

-- Tworzenie dwch procedur.  P1 zaley od P2
CREATE OR REPLACE PROCEDURE P2 AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('W P2!');
END P2;
/

CREATE OR REPLACE PROCEDURE P1 AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('W P1!');
  P2;
END P1;
/

-- Sprawdzanie, czy obie procedury s prawidowe
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('P1', 'P2');

-- Ponowna kompilacja P2, co powoduje natychmiastowe oznaczenie P1 jako nieprawidowej
ALTER PROCEDURE P2 COMPILE;

-- Ponowne zapytanie, aby sprawdzi stan procedur
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('P1', 'P2');

-- cze bazodanowe, ktre wskazuje na ten sam egzemplarz.
-- Trzeba zmodyfikowa acuch_znakw_poczenia i ustawi
-- SQL*Net zgodnie z systemem
CREATE DATABASE LINK loopback
  USING 'lancuch_znakow_polaczenia';

-- Teraz P1 wywouje P2 przez cze
CREATE OR REPLACE PROCEDURE P1 AS
BEGIN
  DBMS_OUTPUT.PUT_LINE('W P1!');
  P2@loopback;
END P1;
/

-- Sprawdzanie, czy obie procedury s prawidowe
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('P1', 'P2');

-- Ponowna kompilacja P2; tym razem nie nastpuje natychmiastowe oznaczenie P1 jako nieprawidowej
ALTER PROCEDURE P2 COMPILE;
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name IN ('P1', 'P2');
