/*
 * SQLFunctions.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje, jak mona wywoywa funkcje skadowane w kodzie SQL
 */

-- Ta funkcja spenia wszystkie warunki
CREATE OR REPLACE FUNCTION FullName (
  p_AuthorID  authors.ID%TYPE)
  RETURN VARCHAR2 IS

  v_Result  VARCHAR2(100);
BEGIN
  SELECT first_name || ' ' || last_name
    INTO v_Result
    FROM authors
    WHERE ID = p_AuthorID;

  RETURN v_Result;
END FullName;
/

DELETE temp_table;

-- Poniewa funkcja FullName spenia wszystkie warunki, mona uywa jej
-- w zapytaniach:
SELECT FullName(ID) full_name         
  FROM authors
  WHERE ID < 10
  ORDER BY full_name;
  
-- Mona take uywa jej w instrukcjach DML:
DECLARE
  CURSOR c_IDs IS
    SELECT ID FROM authors WHERE ID BETWEEN 10 AND 20;
BEGIN
  FOR v_Rec IN c_IDs LOOP
    INSERT INTO temp_table (num_col, char_col)
      VALUES (v_Rec.ID, FullName(v_Rec.ID));
  END LOOP;
END;
/

COLUMN char_col format a60
SELECT *
  FROM temp_table
  ORDER BY num_col;

-- Modyfikacja funkcji FullName tak, aby wstawiaa dane do temp_table
CREATE OR REPLACE FUNCTION FullName (
  p_AuthorID  authors.ID%TYPE)
  RETURN VARCHAR2 IS

  v_Result  VARCHAR2(100);
BEGIN
  SELECT first_name || ' ' || last_name
    INTO v_Result
    FROM authors
    WHERE ID = p_AuthorID;

  INSERT INTO temp_table (num_col, char_col)
    VALUES (p_AuthorID, 'wywolana przez FullName');

  RETURN v_Result;
END FullName;
/

-- To samo zapytanie wywoa teraz bd
SELECT FullName(ID) full_name         
  FROM authors
  WHERE ID < 10
  ORDER BY full_name;
