/*
 * PersistPkg.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje pakiet zdefiniowany przez uytkownika
 */

CREATE OR REPLACE PACKAGE PersistPkg AS
  -- Typ przechowujcy tablic numerw ISBN ksiek
  TYPE t_BookTable IS TABLE OF books.isbn%TYPE
    INDEX BY BINARY_INTEGER;

  -- Maksymalna liczba wierszy zwracanych jednoczenie 
  v_MaxRows NUMBER := 4;

  -- Zwraca do v_MaxRows numerw ISBN
  PROCEDURE ReadBooks(p_BookTable OUT t_BookTable,
                      p_NumRows   OUT NUMBER);

END PersistPkg;
/

CREATE OR REPLACE PACKAGE BODY PersistPkg AS
  -- Zapytanie do tabeli books. Poniewa ten kursor jest globalny w ciele pakietu,
  -- pozostanie dostpny po wywoaniu skierowanym do bazy danych
  CURSOR c_BasicBooks IS
    SELECT isbn
      FROM BOOKS
      WHERE category = 'Oracle Basics'
      ORDER BY title;

  PROCEDURE ReadBooks(p_BookTable OUT t_BookTable,
                      p_NumRows   OUT NUMBER) IS
    v_Done BOOLEAN := FALSE;
    v_NumRows NUMBER := 1;
  BEGIN
    IF NOT c_BasicBooks%ISOPEN THEN
      -- Najpierw otwarcie kursora
      OPEN c_BasicBooks;
    END IF;

    -- Kursor jest otwarty, dlatego mona pobra do v_MaxRows wierszy
    WHILE NOT v_Done LOOP
      FETCH c_BasicBooks INTO p_BookTable(v_NumRows);
      IF c_BasicBooks%NOTFOUND THEN
        -- Nie ma ju wicej danych, dlatego mona zakoczy dziaanie 
        CLOSE c_BasicBooks;
        v_Done := TRUE;
      ELSE
        v_NumRows := v_NumRows + 1;
        IF v_NumRows > v_MaxRows THEN
          v_Done := TRUE;
        END IF;
      END IF;
    END LOOP;

    -- Zwrcenie liczby pobranych wierszy
    p_NumRows := v_NumRows - 1;

  END ReadBooks;
END PersistPkg;
/
show errors
