/*
 * ThreeAuthors.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje funkcj i technik jej wywoywania
 */
 
CREATE OR REPLACE FUNCTION ThreeAuthors(p_ISBN IN books.isbn%TYPE)
  RETURN BOOLEAN AS

  v_Author3 books.author3%TYPE;
BEGIN
  -- Pobranie trzeciego autora podanej ksiki do zmiennej v_Author3
  SELECT author3
    INTO v_Author3
    FROM books
    WHERE isbn = p_ISBN;

  -- Jeli zmienna v_Author3 ma warto NULL, oznacza to, e ksika ma mniej ni
  -- trzech autorw, dlatego funkcja zwraca false. W przeciwnym razie funkcja zwraca true
  IF v_Author3 IS NULL THEN
    RETURN FALSE;
  ELSE
    RETURN TRUE;
  END IF;
END ThreeAuthors;
/

set serveroutput on

BEGIN
  FOR v_Rec IN (SELECT ISBN, title FROM books) LOOP
    IF ThreeAuthors(v_Rec.ISBN) THEN
      DBMS_OUTPUT.PUT_LINE('"' || v_Rec.title || '" ma trzech autorow');
    END IF;
  END LOOP;
END;
/
