/*
 * InventoryOps2.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ta wersja pakietu InventoryOps zawiera dodatkow procedur
 * w ciele pakietu
 */
 
CREATE OR REPLACE PACKAGE BODY InventoryOps AS
  -- Sprawdza podany stan i zgasza bd, jeli ma on warto inn ni
  -- DOSTEPNY, ZAMOWIONY, lub W PLANACH
  PROCEDURE ValidateStatus(p_Status IN inventory.status%TYPE) IS
  BEGIN
    IF p_Status = 'DOSTEPNY' OR
       p_Status = 'ZAMOWIONY' OR
       p_Status = 'W PLANACH' THEN
       RETURN;  -- Bez bdw
    ELSE
      RAISE_APPLICATION_ERROR(20000,
        'Przekazany stan ' || p_Status || ' jest nieprawidlowy');
    END IF;
  END ValidateStatus;
  
  -- Modyfikuje dane okrelonej ksiki 
  PROCEDURE UpdateISBN(p_ISBN IN inventory.isbn%TYPE,
                       p_Status IN inventory.status%TYPE,
                       p_StatusDate IN inventory.status_date%TYPE,
                       p_Amount IN inventory.amount%TYPE) IS
  BEGIN
   ValidateStatus(p_Status);
   UPDATE inventory
      SET status = p_Status, status_date = p_StatusDate, amount = p_Amount
      WHERE isbn = p_ISBN;
      
    -- Sprawdza niezaktualizowane ksiki i zgasza wyjtek 
    IF SQL%ROWCOUNT = 0 THEN
      RAISE e_ISBNNotFound;
    END IF;
  END UpdateISBN;

  -- Usuwa dane okrelonej ksiki
  PROCEDURE DeleteISBN(p_ISBN IN inventory.isbn%TYPE) IS
  BEGIN
    DELETE FROM inventory
      WHERE isbn = p_ISBN;

    -- Sprawdza nieusunite ksiki i zgasza wyjtek 
    IF SQL%ROWCOUNT = 0 THEN
      RAISE e_ISBNNotFound;
    END IF;
  END DeleteISBN;

  -- Zwraca tablic zawierajc ksiki o okrelonym stanie 
  PROCEDURE StatusList(p_Status IN inventory.status%TYPE,
                       p_Books OUT t_ISBNTable,
                       p_NumBooks OUT BINARY_INTEGER) IS
    v_ISBN inventory.isbn%TYPE;
    CURSOR c_Books IS
      SELECT isbn
        FROM inventory
        WHERE status = p_Status;

  BEGIN
    ValidateStatus(p_Status);

    /* p_NumBooks to indeks tablicy. Rozpoczyna si od
     * 0 i jest zwikszany przy kadym przejciu przez ptl pobierajc dane.
     * Na kocu ptli ten indeks bdzie zawiera liczb pobranych 
     * wierszy, ktra jest jednoczenie liczb ksiek zapisanych w 
     * parametrze p_Books */
     p_NumBooks := 0;
     OPEN c_Books;
     LOOP
       FETCH c_Books INTO v_ISBN;
       EXIT WHEN c_Books%NOTFOUND;

       p_NumBooks := p_NumBooks + 1;       
       p_Books(p_NumBooks) := v_ISBN;
     END LOOP;
     CLOSE c_Books;
   END StatusList;
END InventoryOps;
/
show errors
