/*
 * UserDefined.sql
 * Rozdzia 7, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wyjtki zdefiniowane przez uytkownika
 */
 
DECLARE
  -- Wyjtek informujcy o wystpieniu bdu
  e_DuplicateAuthors EXCEPTION;

  -- Identyfikatory trzech autorw
  v_Author1 books.author1%TYPE;
  v_Author2 books.author2%TYPE;
  v_Author3 books.author3%TYPE;
BEGIN
  /* Wyszukiwanie identyfikatorw trzech autorw ksiki 'Oracle9i DBA 101' */
  SELECT author1, author2, author3
    INTO v_Author1, v_Author2, v_Author3
    FROM books
    WHERE title = 'Oracle9i DBA 101';
  
  /* Sprawdzanie, czy identyfikatory nie powtarzaj si */
  IF (v_Author1 = v_Author2) OR (v_Author1 = v_Author3) OR
     (v_Author2 = v_Author3) THEN
     RAISE e_DuplicateAuthors;
  END IF;
END;
/

DECLARE
  -- Wyjtek informujcy o wystpieniu bdu
  e_DuplicateAuthors EXCEPTION;

  -- Identyfikatory trzech autorw
  v_Author1 books.author1%TYPE;
  v_Author2 books.author2%TYPE;
  v_Author3 books.author3%TYPE;
BEGIN
  /* Wyszukiwanie identyfikatorw trzech autorw ksiki 'Oracle9i DBA 101' */
  SELECT author1, author2, author3
    INTO v_Author1, v_Author2, v_Author3
    FROM books
    WHERE title = 'Oracle9i DBA 101';
  
  /* Sprawdzanie, czy identyfikatory nie powtarzaj si */
  IF (v_Author1 = v_Author2) OR (v_Author1 = v_Author3) OR
     (v_Author2 = v_Author3) THEN
     RAISE e_DuplicateAuthors;
  END IF;
EXCEPTION
  WHEN e_DuplicateAuthors THEN
    /* Blok obsugi wykonywany jeli identyfikatory autorw ksiki Oracle9i DBA 101
       powtarzaj si.  Ten kod wstawia do dziennika informacj 
       z opisem tego, co zaszo */
    INSERT INTO log_table (info)
      VALUES ('Identyfikatory autorow ksiazki Oracle9i DBA 101 powtarzaja sie');
END;
/

DECLARE
  -- Wyjtek informujcy o wystpieniu bdu
  e_DuplicateAuthors EXCEPTION;

  -- Identyfikatory trzech autorw
  v_Author1 books.author1%TYPE;
  v_Author2 books.author2%TYPE;
  v_Author3 books.author3%TYPE;
BEGIN
  /* Wyszukiwanie identyfikatorw trzech autorw ksiki 'Oracle9i DBA 101' */
  SELECT author1, author2, author3
    INTO v_Author1, v_Author2, v_Author3
    FROM books
    WHERE title = 'Oracle9i DBA 101';
  
  /* Sprawdzanie, czy identyfikatory nie powtarzaj si */
  IF (v_Author1 = v_Author2) OR (v_Author1 = v_Author3) OR
     (v_Author2 = v_Author3) THEN
     RAISE e_DuplicateAuthors;
  END IF;
EXCEPTION
  WHEN e_DuplicateAuthors THEN
    /* Blok obsugi wykonywany jeli identyfikatory autorw ksiki Oracle9i DBA 101
       powtarzaj si.  Ten kod wstawia do dziennika informacj 
       z opisem tego, co zaszo */
    INSERT INTO log_table (info)
      VALUES ('Identyfikatory autorow ksiki Oracle9i DBA 101 powtarzaja sie');
  WHEN OTHERS THEN
    /* Blok obsugi uruchamiany dla wszystkich innych bdw */
    INSERT INTO log_table (info) VALUES ('Wystapil inny blad');
END;
/

DECLARE
  -- Wyjtek informujcy o wystpieniu bdu
  e_DuplicateAuthors EXCEPTION;

  -- Identyfikatory trzech autorw
  v_Author1 books.author1%TYPE;
  v_Author2 books.author2%TYPE;
  v_Author3 books.author3%TYPE;
  
  -- Code and text of other runtime errors
  v_ErrorCode log_table.code%TYPE;
  v_ErrorText log_table.message%TYPE;
BEGIN
  /* Wyszukiwanie identyfikatorw trzech autorw ksiki 'Oracle9i DBA 101' */
  SELECT author1, author2, author3
    INTO v_Author1, v_Author2, v_Author3
    FROM books
    WHERE title = 'Oracle9i DBA 101';
  
  /* Sprawdzanie, czy identyfikatory nie powtarzaj si */
  IF (v_Author1 = v_Author2) OR (v_Author1 = v_Author3) OR
     (v_Author2 = v_Author3) THEN
     RAISE e_DuplicateAuthors;
  END IF;
EXCEPTION
  WHEN e_DuplicateAuthors THEN
    /* Blok obsugi wykonywany jeli identyfikatory autorw ksiki Oracle9i DBA 101
       powtarzaj si.  Ten kod wstawia do dziennika informacj 
       z opisem tego, co zaszo */
    INSERT INTO log_table (info)
      VALUES ('Identyfikatory autorow ksiazki Oracle9i DBA 101 powtarzaja sie');
  WHEN OTHERS THEN
    /* Blok obsugi uruchamiany dla wszystkich innych bdw */
    v_ErrorCode := SQLCODE;
    -- Warto zwrci uwag na wykorzystanie funkcji SUBSTR
    v_ErrorText := SUBSTR(SQLERRM, 1, 200);
    INSERT INTO log_table (code, message, info) VALUES
      (v_ErrorCode, v_ErrorText, 'Wystapil blad Oracle');
END;
/

DECLARE
  -- Wyjtek informujcy o wystpieniu bdu
  e_DuplicateAuthors EXCEPTION;

  -- Identyfikatory trzech autorw
  v_Author1 books.author1%TYPE;
  v_Author2 books.author2%TYPE;
  v_Author3 books.author3%TYPE;
  
BEGIN
  /* Wyszukiwanie identyfikatorw trzech autorw ksiki 'Oracle9i DBA 101' */
  SELECT author1, author2, author3
    INTO v_Author1, v_Author2, v_Author3
    FROM books
    WHERE title = 'Oracle9i DBA 101';
  
  /* Sprawdzanie, czy identyfikatory nie powtarzaj si */
  IF (v_Author1 = v_Author2) OR (v_Author1 = v_Author3) OR
     (v_Author2 = v_Author3) THEN
     RAISE e_DuplicateAuthors;
  END IF;
EXCEPTION
  WHEN e_DuplicateAuthors THEN
    /* Blok obsugi wykonywany jeli identyfikatory autorw ksiki Oracle9i DBA 101
       powtarzaj si.  Ten kod wstawia do dziennika informacj 
       z opisem tego, co zaszo */
    INSERT INTO log_table (info)
      VALUES ('Identyfikatory autorow ksiazki Oracle9i DBA 101 powtarzaja sie');
  WHEN OTHERS THEN
    INSERT INTO log_table (code, message, info) VALUES
      (NULL, SUBSTR(DBMS_UTILITY.FORMAT_ERROR_STACK, 1, 200),
      'Wystapil blad Oracle');
END;
/