/*
 * trim.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie metody
 * TRIM z API Collection w Oracle10g dla kolekcji
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tablicy VARRAY zawierajcej elementy typu INTEGER
  TYPE number_varray IS VARRAY(5) OF INTEGER;

  -- Definicja zmiennej typu tablicy VARRAY 
  number_list NUMBER_VARRAY := number_varray(1,2,3,4,5);

  -- Definicja procedury lokalnej pobierajcej i wywietlajcej elementy
  PROCEDURE print_list
    (list_in NUMBER_VARRAY) IS

  BEGIN

    -- Przejcie w ptli po moliwych wartociach indeksw listy
    FOR i IN list_in.FIRST..list_in.COUNT LOOP

      -- Wywietlanie elementw
      DBMS_OUTPUT.PUT_LINE(
        'Indeks listy ['||i||'] '||
        'Wartosc listy ['||list_in(i)||']');

    END LOOP;

  END print_list;

BEGIN

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Tablica VARRAY po zainicjowaniu');
  DBMS_OUTPUT.PUT_LINE('-------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

  -- Obcicie elementu listy 
  number_list.TRIM;

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT(CHR(10));
  DBMS_OUTPUT.PUT_LINE('Tablica VARRAY po usunieciu jednego elementu');
  DBMS_OUTPUT.PUT_LINE('--------------------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

  -- Obcicie trzech elementw listy 
  number_list.TRIM(3);

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT(CHR(10));
  DBMS_OUTPUT.PUT_LINE('Tablica VARRAY po usunieciu trzech elementow');
  DBMS_OUTPUT.PUT_LINE('--------------------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

END;
/
