/*
 * limit.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie metody
 * LIMIT z API Collection w Oracle10g dla kolekcji
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tablicy VARRAY zawierajcej elementy typu INTEGER
  TYPE number_varray IS VARRAY(5) OF INTEGER;

  -- Definicja zmiennej typu tablicy VARRAY 
  number_list NUMBER_VARRAY := number_varray(1,2,3);

  -- Definicja procedury lokalnej pobierajcej i wywietlajcej elementy 
  PROCEDURE print_list
    (list_in NUMBER_VARRAY) IS

  BEGIN

    -- Przejcie w ptli po dostpnych indeksach 
    FOR i IN list_in.FIRST..list_in.COUNT LOOP

      -- Wywietlenie elementw
      DBMS_OUTPUT.PUT_LINE(
        'Indeks elementu ['||i||'] '||
        'Wartosc elementu ['||list_in(i)||']');

    END LOOP;

  END print_list;

BEGIN

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Tablica VARRAY po zainicjowaniu');
  DBMS_OUTPUT.PUT_LINE('-------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

  -- Rozszerzenie listy do maksymalnego rozmiaru 
  number_list.EXTEND(number_list.LIMIT - number_list.LAST);

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT(CHR(10));
  DBMS_OUTPUT.PUT_LINE('Tablica VARRAY po rozszerzeniu');
  DBMS_OUTPUT.PUT_LINE('------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

END;
/

