/*
 * first.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie metod
 * FIRST i LAST z API Collection w Oracle10g dla kolekcji
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tabeli zagniedonej elementw typu INTEGER
  TYPE number_table IS TABLE OF INTEGER
    INDEX BY VARCHAR2(9 CHAR);

  -- Definicja zmiennej typu tabeli zagniedonej 
  number_list NUMBER_TABLE;

BEGIN

  -- Utworzenie trzech elementw z indeksami w postaci niepowtarzalnych acuchw znakw 
  number_list('Jeden') := 1;
  number_list('Dwa') := 2;
  number_list('Dziewiec') := 9;

  -- Wywietlenie pierwszego (FIRST) i nastpnego (NEXT) indeksu
  DBMS_OUTPUT.PUT_LINE(
    'Pierwszy indeks ['||number_list.FIRST||']');
  DBMS_OUTPUT.PUT_LINE(
    'Nastepny indeks ['||number_list.NEXT(number_list.FIRST)||']');

  -- Wywietlenie ostatniego (LAST) i poprzedniego (PRIOR) indeksu
  DBMS_OUTPUT.PUT_LINE(CHR(10)||
    'Ostatni indeks ['||number_list.LAST||']');
  DBMS_OUTPUT.PUT_LINE(
    'Poprzedni indeks ['||number_list.PRIOR(number_list.LAST)||']');

END;
/

