/*
 * delete.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie metody
 * DELETE z API Collection w Oracle10g dla zbioru elementw
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tabeli zagniedonej przechowujcej elementy typu INTEGER 
  TYPE number_table IS TABLE OF INTEGER;

  -- Definicja zmiennej typu tabeli zagniedonej 
  number_list NUMBER_TABLE;

  -- Definicja procedury lokalnej pobierajcej i wywietlajcej elementy
  PROCEDURE print_list
    (list_in NUMBER_TABLE) IS

  BEGIN

    -- Przejcie w ptli po moliwych wartociach indeksw listy 
    FOR i IN list_in.FIRST..list_in.LAST LOOP

      -- Sprawdzanie, czy element o danym indeksie jest dostpny 
      IF list_in.EXISTS(i) THEN

        -- Wywietlanie elementu
        DBMS_OUTPUT.PUT_LINE('Lista ['||list_in(i)||']');

      END IF;

    END LOOP;

  END print_list;

BEGIN

  -- Sprawdza, czy nie istnieje element o indeksie jeden 
  IF NOT number_list.EXISTS(1) THEN

    -- Konstrukcja kolekcji
    number_list := number_table(1,2,3,4,5);

  END IF;

  -- Wywietlanie nagwka
  DBMS_OUTPUT.PUT_LINE('Tabela zagniezdzona przed usuwaniem');
  DBMS_OUTPUT.PUT_LINE('-----------------------------------');

  -- Wywietlenie listy
  print_list(number_list);

  -- Usunicie elementw
  number_list.DELETE(2,4);

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE(CHR(10)||
                       'Tabela zagniezdzona po usuwaniu');
  DBMS_OUTPUT.PUT_LINE('-------------------------------');

  -- Wywietlenie listy
  print_list(number_list);  

END;
/

