/*
 * create_varray4.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt definiuje tablic varray za pomoc konstruktora i elementu null, a nastpnie 
 * rozszerza j po jednym elemencie
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

BEGIN

  -- Jeli skrypt znajdzie wiersz, usuwa go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INTEGER_VARRAY') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE integer_varray';
    COMMIT;

  END LOOP;

END;
/

CREATE OR REPLACE TYPE integer_varray
  AS VARRAY(100) OF INTEGER NOT NULL;
/

DECLARE

  -- Deklaracja i inicjowanie tablicy VARRAY 
  varray_integer INTEGER_VARRAY := integer_varray();

BEGIN

  -- Przejcie w ptli po wszystkich rekordach
  FOR i IN 1..varray_integer.LIMIT LOOP

    -- Inicjowanie wiersza
    varray_integer.EXTEND;

  END LOOP;

    -- Wywietlanie w oknie konsoli liczby zainicjowanych wierszy
    dbms_output.put     ('Wiersze zainicjowane w varray_integer');
    dbms_output.put_line('['||varray_integer.COUNT||']');

END;
/

