/*
 * create_nestedtable4.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy dwie tablice varray i jedn tabel zagniedon w bazie danych, a nastpnie
 * przypisuje zawarto tablic varray do tej tabeli.
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Definicja tablicy VARRAY acuchw znakw o zmiennej dugoci zawierajcej cztery wiersze 
CREATE OR REPLACE TYPE card_unit_varray
  AS VARRAY(13) OF VARCHAR2(10  CHAR);
/

-- Definicja tablicy VARRAY acuchw znakw o zmiennej dugoci zawierajcej cztery wiersze
CREATE OR REPLACE TYPE card_suit_varray
  AS VARRAY(4) OF VARCHAR2(5  CHAR);
/

-- Definicja tabeli acuchw znakw o zmiennej dugoci
CREATE OR REPLACE TYPE card_deck_table
  AS TABLE OF VARCHAR2(16  CHAR);
/

DECLARE

  -- Definicja licznika sucego do zarzdzania kartami w talii (od 1 do 52)
  counter INTEGER := 0;

  -- Deklaracja i inicjowanie kolorw
  suits CARD_SUIT_VARRAY :=
    card_suit_varray('Trefl'
                    ,'Karo'
                    ,'Kier'
                    ,'Pik');

  -- Deklaracja i inicjowanie tablicy VARRAY z nazwami kart
  units CARD_UNIT_VARRAY :=
    card_unit_varray('As','Dwojka','Trojka','Czworka'
                    ,'Piatka','Szostka','Sidemka','Osemka'
                    ,'Dziewiatka','Dziesiatka','Walet','Dama'
                    ,'Krl');

  -- Deklaracja i inicjowanie pustej tabeli zagniedonej
  deck CARD_DECK_TABLE := card_deck_table(); 

BEGIN

  -- Przejcie w ptli po czterech kolorach
  FOR i IN 1..suits.COUNT LOOP

    -- Przejcie w ptli po nazwach trzynastu kart
    FOR j IN 1..units.COUNT LOOP

      -- Zwikszenie wartoci licznika
      counter := counter + 1;

      -- Inicjowanie wiersza
      deck.EXTEND;

      -- Przypisanie wartoci do danego elementu 
      deck(counter) := units(j)||' '||suits(i);

    END LOOP;

  END LOOP;

  -- Wywietlenie nagwka
  dbms_output.put_line('Talia kart wyswietlona wedlug kolorow.');
  dbms_output.put_line('--------------------------------------');

  -- Przejcie w ptli po talii kart
  FOR i IN 1..counter LOOP

    -- Wywietlenie zawartoci
    dbms_output.put_line('['||deck(i)||']');

  END LOOP;

END;
/

