/*
 * create_nestedtable2.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy pust tabel zagniedon, a nastpnie rozszerza j po jednym elemencie
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tabeli zagniedonej acuchw znakw o zmiennej dugoci
  TYPE card_suit IS TABLE OF VARCHAR2(5 CHAR);

  -- Deklarowanie i inicjowanie przy uyciu pustego zbioru wierszy
  cards CARD_SUIT := card_suit();

BEGIN

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Inicjowanie wiersza
    cards.EXTEND;

    -- Przypisanie wartoci do indeksowanych elementw tabeli
    IF    i = 1 THEN
      cards(i) := 'As';
    ELSIF i = 2 THEN
      cards(i) := 'Dwojka';
    ELSIF i = 3 THEN
      cards(i) := 'Trojka';
    END IF;

  END LOOP;

  -- Wywietlanie nagwka
  dbms_output.put_line(
    'Tabela zagniezdzona zainicjowana asem, dwojka i trojka.');
  dbms_output.put_line(
    '--------------------------------------------------------');

  -- Przejcie w ptli po rekordach w celu wywietlanie wartoci tabeli zagniedonej
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('cards ['||i||'] ');
    dbms_output.put_line('['||cards(i)||']');

  END LOOP;

END;
/

