/*
 * bulk_collect3.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje, jak pobiera dane do elementw
 * tabeli jzyka PL/SQL bez stosowania pobierania masowego
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

BEGIN
  FOR i IN (SELECT null
            FROM user_tables
            WHERE table_name = 'BULK_NUMBERS') LOOP
    EXECUTE IMMEDIATE 'DROP TABLE bulk_numbers CASCADE CONSTRAINTS';
  END LOOP;
END;
/

-- Tworzenie tabeli na potrzeby przykadu
CREATE TABLE bulk_numbers
(number_id                INTEGER              NOT NULL
,CONSTRAINT number_id_pk  PRIMARY KEY (number_id));

-- Uycie instrukcji FORALL w celu przeniesienia tablicy asocjacyjnej do tabeli
DECLARE

  -- Definicja tabeli zagniedonej liczb cakowitych
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE
    INDEX BY BINARY_INTEGER;

  -- Definicja zmiennej typu tabeli zagniedonej
  number_list NUMBER_TABLE;

BEGIN

  -- Przejcie w ptli od 1 do 10000  i zwikszanie tablicy asocjacyjnej
  FOR i IN 1..10000 LOOP

    INSERT
    INTO     bulk_numbers
    VALUES  (i);

  END LOOP;

  -- Zatwierdzenie rekordw
  COMMIT;

END;
/

-- Pobieranie danych do tabeli zagniedonej
DECLARE

  -- Definicja tabeli zagniedonej liczb cakowitych
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE
    INDEX BY BINARY_INTEGER;

  -- Definicja zmiennej typu tabeli zagniedonej
  number_list NUMBER_TABLE;

BEGIN

  -- Pobieranie po kolei wszystkich wierszy
  FOR i IN 1..10000 LOOP

    SELECT   number_id
    INTO     number_list(i)
    FROM     bulk_numbers
    WHERE    number_id = i
    ORDER BY 1;

  END LOOP;

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Pobieranie wiersz po wierszu:');
  DBMS_OUTPUT.PUT_LINE('-----------------------------');

  -- Przejcie w ptli w celu wywietlenia elementw
  FOR i IN number_list.FIRST..number_list.LAST LOOP

    -- Wywietlenie tylko dwch pierwszych i ostatnich elementw
    IF i <= 2 OR i >= 9999 THEN

      -- Wywietlenie indeksowanego elementu z tabeli
      DBMS_OUTPUT.PUT_LINE('Numer ['||number_list(i)||']');

    END IF;

  END LOOP;

END;
/

