/*
 * create_function2.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie typw rekordowych jako wartoci zwracanych przez funkcj
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

@create_record1.sql

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony, a take
-- usuwa istniejc struktur rekordu ze uywanego schematu bazy danych
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_ADDRESS_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_address_record';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_record';
    COMMIT;

  END LOOP;

END;
/

-- Tworzenie typu obiektowego dla bazy danych
CREATE OR REPLACE TYPE individual_record AS OBJECT
  (individual_id  INTEGER
  ,first_name     VARCHAR2(30 CHAR)
  ,middle_initial VARCHAR2(1 CHAR)
  ,last_name      VARCHAR2(30 CHAR)
  ,CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT)
  INSTANTIABLE NOT FINAL;
/

show errors

-- Tworzenie ciaa obiektu z bazy danych
CREATE OR REPLACE TYPE BODY individual_record AS
  CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT IS
  BEGIN
    self.individual_id := individual_id;
    self.first_name := first_name;
    self.middle_initial := middle_initial;
    self.last_name := last_name;
    RETURN;
  END;
END;
/

show errors


-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja zmiennej typu rekordowego
  individual INDIVIDUAL_RECORD;

  -- Definicja funkcji lokalnej zwracajcej warto typu rekordowego
  FUNCTION get_row 
    (individual_id_in INTEGER)
  RETURN INDIVIDUAL_RECORD IS

    -- Definicja kursora zwracajcego wiersz z tabeli individuals
    CURSOR c
      (individual_id_cursor INTEGER) IS
      SELECT   *
      FROM     individuals
      WHERE    individual_id = individual_id_cursor;

  BEGIN

    -- Przejcie w ptli po kursorze i pobranie jednego wiersza
    FOR i IN c(individual_id_in) LOOP

      -- Zwrcenie obiektu utworzonego na podstawie atrybutu %ROWTYPE
      RETURN   individual_record(i.individual_id
                                ,i.first_name
                                ,i.middle_initial
                                ,i.last_name);
    END LOOP;

  END get_row;

BEGIN

  -- Przypisanie do zmiennej wartoci zwrconej przez funkcj
  individual := get_row(1);
  
  -- Wywietlenie wynikw
  dbms_output.put_line(CHR(10));
  dbms_output.put_line('INDIVIDUAL_ID  : '||individual.individual_id);
  dbms_output.put_line('FIRST_NAME     : '||individual.first_name);
  dbms_output.put_line('MIDDLE_INITIAL : '||individual.middle_initial);
  dbms_output.put_line('LAST_NAME      : '||individual.last_name);

END;
/    
