/*
 * LevelUpdate.sql
 * Rozdzia 4, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie pseudokolumny LEVEL i
 * uywanie poziomw przy aktualizacji.
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables
exec clean_schema.ind

CREATE TABLE books (
  isbn      VARCHAR2(10) PRIMARY KEY,
  parent_isbn VARCHAR2(10),
  series    VARCHAR2(20),
  category  VARCHAR2(20),
  title     VARCHAR2(100),
  num_pages NUMBER,
  price     NUMBER,
  copyright NUMBER(4));

INSERT INTO books (isbn, parent_isbn, series, category, title, num_pages, price, copyright)
  VALUES ('72191473', '72121467', 'Oracle PL/SQL', 'Oracle Server', 'Oracle9i PL/SQL Programming', 664, 49.99, 2002);

INSERT INTO books (isbn, parent_isbn, series, category, title, num_pages, price, copyright)
  VALUES ('72121467', null, 'Oracle PL/SQL', 'Oracle Server', 'Oracle8i Advanced PL/SQL Programming', 772, 49.99, 2000);

INSERT INTO books (isbn, parent_isbn, series, category, title, num_pages, price, copyright)
  VALUES ('72230665', '72191473', 'Oracle PL/SQL', 'Oracle Server', 'Oracle Database 10g PL/SQL Programming', 1008, 54.99, 2004);

INSERT INTO books (isbn, parent_isbn, series, category, title, num_pages, price, copyright)
  VALUES ('72132302', null, 'Oracle Ebusiness', 'Oracle Ebusiness', 'Oracle E-Business Suite Financials Handbook', 820, 59.99, 2002);

commit;

PROMPT
PROMPT ** Modyfikacja tabeli books poprzez dodanie kolumny position
PROMPT

ALTER TABLE books
ADD position NUMBER(10);

PROMPT
PROMPT ** Uruchomienie bloku anonimowego, ktory aktualizuje rekordy w tabeli
PROMPT **  i podaje ich biezaca pozycje
PROMPT

SET SERVEROUTPUT ON

DECLARE
   v_level PLS_INTEGER;
   v_title BOOKS.TITLE%TYPE;

   CURSOR cur_tree
   IS
      SELECT isbn, title, series
      FROM books;
BEGIN

FOR l IN cur_tree
LOOP

   SELECT max(LEVEL)
   INTO v_level
   FROM books
   START WITH isbn = l.isbn
   CONNECT BY PRIOR parent_isbn = isbn;

   UPDATE books
   SET position = v_level
   WHERE isbn = l.isbn;

END LOOP;

COMMIT;

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(sqlerrm);
END;
/

PROMPT
PROMPT ** Sprawdzanie danych w tabeli w celu upewnienia sie, ze rekordy zostaly
PROMPT **  zaktualizowane.
PROMPT

SET PAGES 9999
SELECT title, position
FROM books
ORDER BY series, position;

PROMPT
PROMPT ** Wstawianie rekordu z ksiazka o Oracle PL/SQL, wersja 8.0,
PROMPT **  i aktualizacja ksiazki o wersji 8i poprzez dolaczenie wartosci parent_isbn
PROMPT

INSERT INTO books (isbn, parent_isbn, series, category, title, num_pages, price, copyright)
  VALUES ('111111', null, 'Oracle PL/SQL', 'Oracle Server', 'Oracle8.0 PL/SQL Programming', 772, 49.99, 2000);

UPDATE books
SET parent_isbn = '111111'
WHERE isbn = '72121467';

COMMIT;

PROMPT
PROMPT
PROMPT ** Po zakonczeniu obslugi instrukcji insert i update nalezy ponownie uruchomic instrukcje select,
PROMPT **  aby przekonac sie, ze wartosc kolumny position nowego rekordu to null.
PROMPT

SELECT title, position
FROM books
ORDER BY series, position;

PROMPT
PROMPT ** Ponowne uruchomienie tego samego bloku anonimowego w celu aktualizacji kolumny position
PROMPT

DECLARE
   v_level PLS_INTEGER;
   v_title BOOKS.TITLE%TYPE;

   CURSOR cur_tree
   IS
      SELECT isbn, title, series
      FROM books;
BEGIN

FOR l IN cur_tree
LOOP

   SELECT max(LEVEL)
   INTO v_level
   FROM books
   START WITH isbn = l.isbn
   CONNECT BY PRIOR parent_isbn = isbn;

   UPDATE books
   SET position = v_level
   WHERE isbn = l.isbn;

END LOOP;

COMMIT;

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(sqlerrm);
END;
/

PROMPT
PROMPT ** Zatwierdzenie zmian za pomoca instrukcji select
PROMPT

SELECT title, position
FROM books
ORDER BY series, position;

PROMPT
PROMPT ** Nie tylko nowy rekord zostal zaktualizowany, ale pozycje wszystkich pozostalych
PROMPT **  rekordow zostaly zmienione wzgledem
PROMPT **  nowego elementu nadrzednego.
PROMPT