/*
 * Visibility.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje widoczno zmiennych
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

SET SERVEROUTPUT ON

DECLARE
   v_visible VARCHAR2(30);
   v_hidden VARCHAR2(30);
BEGIN
   v_visible := 'v_visible w bloku zewnetrznym';
   v_hidden := 'v_hidden w bloku zewnetrznym';

   DBMS_OUTPUT.PUT_LINE('*** BLOK ZEWNETRZNY ***');
   DBMS_OUTPUT.PUT_LINE(v_visible);
   DBMS_OUTPUT.PUT_LINE(v_hidden);
   DBMS_OUTPUT.PUT_LINE('==================');

   DECLARE
      v_hidden NUMBER(10);
   BEGIN
      DBMS_OUTPUT.PUT_LINE('*** BLOK WEWNETRZNY ***');
      v_hidden := 'v_hidden w bloku wewnetrznym';
      DBMS_OUTPUT.PUT_LINE(v_hidden);
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.PUT_LINE('Zmienna v_hidden typu VARCHAR2 zostala...ukryta');
   END;
END;
/

<<l_outer_block>>
DECLARE
   v_visible VARCHAR2(30);
   v_hidden VARCHAR2(30);
BEGIN
   v_visible := 'v_visible w bloku zewnetrznym';
   v_hidden := 'v_hidden w bloku zewnetrznym';

   DBMS_OUTPUT.PUT_LINE('*** BLOK ZEWNETRZNY ***');
   DBMS_OUTPUT.PUT_LINE(v_visible);
   DBMS_OUTPUT.PUT_LINE(v_hidden);
   DBMS_OUTPUT.PUT_LINE('==================');

   DECLARE
      v_hidden NUMBER(10);
   BEGIN
      DBMS_OUTPUT.PUT_LINE('*** BLOK WEWNETRZNY ***');
      l_outer_block.v_hidden := 'v_hidden w bloku wewnetrznym';
      DBMS_OUTPUT.PUT_LINE(l_outer_block.v_hidden);
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.PUT_LINE('Zmienna v_hidden typu VARCHAR2 zostala...ukryta');
   END;
END;
/