/*
 * Trigger.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie wyzwalaczy
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

set feedback on
set pages 9999 serveroutput on size 1000000

CREATE TABLE authors (
  id         NUMBER PRIMARY KEY,
  first_name VARCHAR2(50),
  last_name  VARCHAR2(50)
);

INSERT INTO authors (id, first_name, last_name)
  VALUES (1, 'Marlene', 'Theriault');

INSERT INTO authors (id, first_name, last_name)
  VALUES (2, 'Rachel', 'Carmichael');

INSERT INTO authors (id, first_name, last_name)
  VALUES (3, 'James', 'Viscusi');

INSERT INTO authors (id, first_name, last_name)
  VALUES (4, 'Michael', 'Abbey');

INSERT INTO authors (id, first_name, last_name)
  VALUES (5, 'Michael', 'Corey');

INSERT INTO authors (id, first_name, last_name)
  VALUES (6, 'Scott', 'Urman');

INSERT INTO authors (id, first_name, last_name)
  VALUES (7, 'Ron', 'Hardman');

INSERT INTO authors (id, first_name, last_name)
  VALUES (8, 'Mike', 'McLaughlin');

COMMIT;

PROMPT
PROMPT ** To oryginalny rekord
PROMPT

SELECT id, first_name, last_name
FROM authors
WHERE last_name = 'HARDMAN';

PROMPT
PROMPT ** Tworzenie wyzwalacza AFTER UPDATE dla tabeli AUTHORS
PROMPT

CREATE OR REPLACE TRIGGER author_trig
   AFTER UPDATE OF first_name
   ON authors
   FOR EACH ROW
WHEN (OLD.first_name != NEW.first_name)
BEGIN
   DBMS_OUTPUT.PUT_LINE('Imie '
                        ||:OLD.first_name
                        ||' zostalo zmienione na '
                        ||:NEW.first_name);
END;
/

PROMPT
PROMPT ** Aktualizacja kolumny first_name
PROMPT

UPDATE authors
SET first_name = 'Ronald'
WHERE first_name = 'Ron';
