/*
 * CompileError.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje ostrzeenia czasu kompilacji
 *   generowane przez Oracle
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

SET SERVEROUTPUT ON PAGES 9999

PROMPT
PROMPT ** Tworzenie procedury, ktora nie skompiluje sie **
PROMPT

CREATE OR REPLACE PROCEDURE compile_error
   AS
     v_timestamp timestamp;
BEGIN
   SELECT systimestamp
   INTO v_timestamp
   FROM duall;

   DBMS_OUTPUT.PUT_LINE(v_timestamp);
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END;
/

PROMPT 
PROMPT ** Pokazywanie przyczyn niepowodzenia kompilacji **
PROMPT

SHOW ERRORS

PROMPT
PROMPT ** Kod i numer wiersza ulatwiaja rozwiazywanie problemow **
PROMPT

SELECT line||' '||text PROCEDURE
FROM user_source
WHERE name = 'COMPILEERROR';

PROMPT
PROMPT ** Pokazuje, ze procedura jest oznaczona jako nieprawidlowa **
PROMPT
COL object_name FORMAT A15
COL status FORMAT A10
SELECT object_name, status
  FROM user_objects
  WHERE object_name = 'COMPILEERROR';

PROMPT
PROMPT ** Ponowne utworzenie procedury compileerror - tym razem z poprawna
PROMPT **  nazwa tabeli
PROMPT

CREATE OR REPLACE PROCEDURE CompileError
   AS
     v_timestamp timestamp;
BEGIN
   SELECT systimestamp
   INTO v_timestamp
   FROM dual;

   DBMS_OUTPUT.PUT_LINE(v_timestamp);
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END;
/

exec compileerror

