unsigned int argb8888_to_rgb565 (unsigned int color)
{
  /*
    wejcie:  aaaaaaaarrrrrrrrggggggggbbbbbbbb
    
    wyjcie: 0000000000000000rrrrrggggggbbbbb
  */
  
  return
    /* czerwony   */ ((color >> 8) & 0xF800) |
    /* zielony    */ ((color >> 5) & 0x07E0) |
    /* niebieski  */ ((color >> 3) & 0x001F);
}

int argb8888_tests(int loops)
{
  int x = 0;
  
  while (loops--) {
    x += argb8888_to_rgb565(loops * 7919);
  }
  
  return x;
}

int argb8888_asm_tests(int loops)
{
  int x = 0;
  
  while (loops--) {
    x += argb8888_to_rgb565(loops * 7919);
  }
  
  return x;
}
