package com.apress.proandroid.power;

//Zwr uwag na sowo kluczowe 'static' (usu je i zobacz, co si stanie)
import static android.os.BatteryManager.*; 

import java.util.List;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.PowerManager;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;

public class BatteryInfoActivity extends Activity {
	private static final String TAG = "BatteryInfo";
	
	private BroadcastReceiver mBatteryChangedReceiver;
	private BroadcastReceiver mConnectivityChangedReceiver;
	private BroadcastReceiver mBackgroundDataSettingReceiver;
	private LocationListener mLocationListener;
	private SensorEventListener mSensorEventListener;
	
	private TextView mBatteryTextView;
	private TextView mConnectivityTextView;

	private void runInWakeLock(Runnable runnable, int flags) {
		PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
		PowerManager.WakeLock wl = pm.newWakeLock(flags, "Blokada WakeLock");
		wl.acquire();
		runnable.run();
		wl.release();
	}
	
	public void onClickCancelAlarms(View v) {
		setupAlarm(true);
	}

    private void setupInexactAlarm(boolean cancel) {
        AlarmManager am = (AlarmManager) getSystemService(Context.ALARM_SERVICE);

        Intent intent = new Intent(this, MyService.class);

        PendingIntent pendingIntent = PendingIntent.getService(this, 0, intent, 0);

        if (cancel) {
            am.cancel(pendingIntent); // Anulowanie wszystkich alarmw, ktrych intencja pasuje do podanej
        } else {
            long interval = AlarmManager.INTERVAL_HOUR;
            long firstInterval = DateUtils.MINUTE_IN_MILLIS * 30;

            am.setInexactRepeating(AlarmManager.RTC, firstInterval, interval, pendingIntent);
        }
    }

	private void setupAlarm(boolean cancel) {
		AlarmManager am = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
		
		Intent intent = new Intent(this, MyService.class);
		
		PendingIntent pendingIntent = PendingIntent.getService(this, 0, intent, 0);
		
		if (cancel) {
			am.cancel(pendingIntent);
		} else {
			long interval = DateUtils.HOUR_IN_MILLIS * 1;
			long firstInterval = DateUtils.MINUTE_IN_MILLIS * 30;

			am.setRepeating(AlarmManager.RTC_WAKEUP, firstInterval, interval, pendingIntent);
		}
	}
	
	private static String powerRequirementCodeToString(int powerRequirement) {
		switch (powerRequirement) {
		case Criteria.POWER_LOW: return "Niskie";
		case Criteria.POWER_MEDIUM: return "Umiarkowane";
		case Criteria.POWER_HIGH: return "Wysokie";
		default: return String.format("Nieznane (%d)", powerRequirement);
		}
	}

	private void showLocationProvidersPowerRequirement() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		
		List<String> providers = lm.getAllProviders();
		
		if (providers != null) {
			for (String name : providers) {
				LocationProvider provider = lm.getProvider(name);
				if (provider != null) {
					int powerRequirement = provider.getPowerRequirement();
					Log.i(TAG, name + " Poziom zuycia energii: " + powerRequirementCodeToString(powerRequirement));
				}
			}
		}
	}
	
	private LocationProvider getMyLocationProvider() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		Criteria criteria = new Criteria();
		LocationProvider provider = null;
		
		criteria.setAccuracy(Criteria.ACCURACY_COARSE);
		criteria.setAltitudeRequired(true);
		criteria.setBearingAccuracy(Criteria.NO_REQUIREMENT);
		criteria.setBearingRequired(false);
		criteria.setCostAllowed(true); // Naley umoliwi ustawienie tej opcji uytkownikowi
		criteria.setHorizontalAccuracy(Criteria.ACCURACY_LOW);
		criteria.setPowerRequirement(Criteria.POWER_LOW);
		criteria.setSpeedAccuracy(Criteria.ACCURACY_MEDIUM);
		criteria.setSpeedRequired(false);
		criteria.setVerticalAccuracy(Criteria.NO_REQUIREMENT);
		
		List<String> names = lm.getProviders(criteria, false); // Tylko dokadne dopasowanie
		
		if ((names != null) && ! names.isEmpty()) {
			for (String name : names) {
				provider = lm.getProvider(name);
				Log.d(TAG, "[getMyLocationProvider] " + provider.getName() + " " + provider);
			}
			provider = lm.getProvider(names.get(0));
		} else {
			Log.d(TAG, "Nie mona znale idealnie pasujcego dostawcy");
			
			String name = lm.getBestProvider(criteria, false);
			
			if (name != null) {
				provider = lm.getProvider(name);
				Log.d(TAG, "[getMyLocationProvider] " + provider.getName() + " " + provider);
			}
		}
		
		return provider;
	}
	
	private LocationProvider getMyLocationProvider2() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		Criteria criteria = new Criteria();
		LocationProvider provider = null;
		
		criteria.setAccuracy(Criteria.ACCURACY_COARSE);
		criteria.setAltitudeRequired(true);
		criteria.setBearingAccuracy(Criteria.NO_REQUIREMENT);
		criteria.setBearingRequired(false);
		criteria.setCostAllowed(true); // Naley umoliwi ustawienie tej opcji uytkownikowi
		criteria.setHorizontalAccuracy(Criteria.ACCURACY_LOW);
		criteria.setPowerRequirement(Criteria.POWER_LOW);
		criteria.setSpeedAccuracy(Criteria.ACCURACY_MEDIUM);
		criteria.setSpeedRequired(false);
		criteria.setVerticalAccuracy(Criteria.NO_REQUIREMENT);
		
		String name = lm.getBestProvider(criteria, false);

		if (name != null) {
			provider = lm.getProvider(name);
			
			if (! provider.meetsCriteria(criteria)) {
				Log.d(TAG, "[getMyLocationProvider] Dostawca nie spenia kryteriw");
				
				if (provider.getPowerRequirement() == Criteria.POWER_HIGH) {
					// Wysokie zuycie energii jest akceptowane tylko wtedy, jeli zapewnia
					// wysz dokadno
					
					if (provider.getAccuracy() != Criteria.ACCURACY_FINE) {
						// Znajdowanie innego dostawcy
					}
				}
			}
			
			Log.d(TAG, "[getMyLocationProvider] " + provider.getName() + " " + provider);
		}
		
		return provider;
	}
	
	private Location getLastKnownLocation() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		List<String> names = lm.getAllProviders();
		Location location = null;
		if (names != null) {
			for (String name : names) {
				if (! LocationManager.PASSIVE_PROVIDER.equals(name)) {
					Location l = lm.getLastKnownLocation(name);
					if (location == null || l.getTime() > location.getTime()) {
						location = l;
						
						/*
						 * Ostrzeenie: zegary dostawcw opartych na GPS-ie i sieci 
                         * mog nie by zsynchronizowane, dlatego porwnywanie czasu
                         * nie jest najlepszym pomysem (aplikacja i tak moe pobra
                         * dawniejsz lokalizacj)
						 */
					}
				}
			}
		}
		return location;
	}
	
	private void unregisterSensorEventListener(SensorEventListener listener) {
		SensorManager sm = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		sm.unregisterListener(listener);
	}
	
	private SensorEventListener registerWithAccelerometer() {
		SensorManager sm = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		List<Sensor> sensors = sm.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors != null && ! sensors.isEmpty()) {
			SensorEventListener listener = new SensorEventListener() {

				@Override
				public void onAccuracyChanged(Sensor sensor, int accuracy) {
					Log.i(TAG, "Dokadno zmieniono na " + accuracy);
				}

				@Override
				public void onSensorChanged(SensorEvent event) {
					/*
					 * Akcelerometr: tablica 3 wartoci
					 * 
					 * values[0] = przyspieszenie minus Gx na osi x 
					 * values[1] = przyspieszenie minus Gy na osi y 
					 * values[2] = przyspieszenie minus Gz na osi z 
					 */
					
					//Log.i(TAG, String.format("x:%.2f y:%.2f z:%.2f ", event.values[0], event.values[1], event.values[2]));
					
					// Wykonywanie operacji
				}
			};
			
			Sensor sensor = sensors.get(0);
			Log.d(TAG, "Uywanie czujnika " + sensor.getName() + " firmy " + sensor.getVendor());
			sm.registerListener(listener, sensor, SensorManager.SENSOR_DELAY_NORMAL);
			return listener;
		}
		return null;
	}
	
	private void requestLocationUpdates() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		
		List<String> providers = lm.getAllProviders();
		
		if (providers != null && ! providers.isEmpty()) {
			for (String name : providers) {
				if (! LocationManager.PASSIVE_PROVIDER.equals(name)) {
					Log.i(TAG, "danie aktualizacji lokalizacji od " + name);
					lm.requestLocationUpdates(name, 0, 0, mLocationListener);
					//lm.requestLocationUpdates(name, DateUtils.HOUR_IN_MILLIS * 1, 100, listener); // Rzadsze aktualizacje
				}
			}
		}
	}

	private void requestPassiveLocationUpdates() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		LocationListener listener = new LocationListener() {

			@Override
			public void onLocationChanged(Location location) {
				Log.i(TAG, "[PASSIVE] " + location.toString());
				
				// Zamy, e akceptowane s tylko aktualizacje od dostawcy GPS
				if (LocationManager.GPS_PROVIDER.equals(location.getProvider())) {
					
					// Jeli wana jest precyzja, naley wywoa metod getAccuracy()
					if (location.hasAccuracy() && (location.getAccuracy() < 10.0f)) {
						
						// Wykonywanie operacji
					}
				}
			}

			@Override
			public void onProviderDisabled(String provider) {
				Log.i(TAG, "[PASSIVE] " + provider + " dostawc wyczono");
			}

			@Override
			public void onProviderEnabled(String provider) {
				Log.i(TAG, "[PASSIVE] " + provider + " dostawc wczono");
			}

			@Override
			public void onStatusChanged(String provider, int status, Bundle extras) {
				Log.i(TAG, "[PASSIVE] " + provider + " zmieni stan na " + status);
			}
		};

		Log.i(TAG, "danie pasywnej aktualizacji lokalizacji");
		lm.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, DateUtils.SECOND_IN_MILLIS * 30, 100, listener);
	}

	private void disableLocationListener() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		lm.removeUpdates(mLocationListener);
    }

	private void showPowerUsageSummary() {
		try {
			Intent intent = new Intent(Intent.ACTION_POWER_USAGE_SUMMARY);
			startActivity(intent);
		} catch (ActivityNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	public void onClickShowPowerUsageSummary(View v) {
		showPowerUsageSummary();
	}
	
	private void enableBatteryReceiver(boolean enabled) {
		PackageManager pm = getPackageManager();
		ComponentName receiverName = new ComponentName(this, BatteryReceiver.class);
		int newState;
		if (enabled) {
			newState = PackageManager.COMPONENT_ENABLED_STATE_ENABLED;
		} else {
			newState = PackageManager.COMPONENT_ENABLED_STATE_DISABLED;
		}
		pm.setComponentEnabledSetting(receiverName, newState, PackageManager.DONT_KILL_APP);
	}
	
	private static String healthCodeToString(int health) {
		switch (health) {
		//case BATTERY_HEALTH_COLD: return "Zimna"; // wersja 11. API 
		case BATTERY_HEALTH_DEAD: return "Zuyta";
		case BATTERY_HEALTH_GOOD: return "Dobra";
		case BATTERY_HEALTH_OVERHEAT: return "Za wysoka temperatura";
		case BATTERY_HEALTH_OVER_VOLTAGE: return "Za wysokie napici";
		case BATTERY_HEALTH_UNSPECIFIED_FAILURE: return "Nieokrelony bd";
		case BATTERY_HEALTH_UNKNOWN:
		default: return "Brak informacji";
		}
	}
	
	private static String pluggedCodeToString(int plugged) {
		switch (plugged) {
		case 0: return "Bateria";
		case BATTERY_PLUGGED_AC: return "Gniazdko";
		case BATTERY_PLUGGED_USB: return "USB";
		default: return "Brak informacji";
		}
	}
	
	private static String statusCodeToString(int status) {
		switch (status) {
		case BATTERY_STATUS_CHARGING: return "adowanie";
		case BATTERY_STATUS_DISCHARGING: return "Rozadowywanie";
		case BATTERY_STATUS_FULL: return "Pena";
		case BATTERY_STATUS_NOT_CHARGING: return "Niepodczona";
		case BATTERY_STATUS_UNKNOWN:
		default: return "Brak informacji";
		}
	}
	
	private void showBatteryInfo(Intent intent) {
		if (intent != null) {
			int health = intent.getIntExtra(EXTRA_HEALTH, BATTERY_HEALTH_UNKNOWN);
			String healthString = "Stan: " + healthCodeToString(health);
			Log.i(TAG, "Stan: " + healthString);
			
			int level = intent.getIntExtra(EXTRA_LEVEL, 0);
			int scale = intent.getIntExtra(EXTRA_SCALE, 100);
			float percentage = (scale != 0) ? (100.f * (level / (float)scale)) : 0.0f;
			String levelString = String.format("Poziom: %d/%d (%.2f%%)", level, scale, percentage);
			Log.i(TAG, levelString);
			
			int plugged = intent.getIntExtra(EXTRA_PLUGGED, 0);
			String pluggedString = "rdo zasilania: " + pluggedCodeToString(plugged);
			Log.i(TAG, pluggedString);
			
			boolean present = intent.getBooleanExtra(EXTRA_PRESENT, false);
			String presentString = "Dostpna? " + (present ? "Tak" : "Nie");
			Log.i(TAG, presentString);
			
			int status = intent.getIntExtra(EXTRA_STATUS, BATTERY_STATUS_UNKNOWN);
			String statusString = "Stan: " + statusCodeToString(status);
			Log.i(TAG, statusString);
			
			String technology = intent.getStringExtra(EXTRA_TECHNOLOGY);
			String technologyString = "Technologia: " + technology;
			Log.i(TAG, technologyString);
			
			int temperature = intent.getIntExtra(EXTRA_STATUS, Integer.MIN_VALUE);
			String temperatureString = "Temperatura: " + temperature;
			Log.i(TAG, temperatureString);
			
			int voltage = intent.getIntExtra(EXTRA_VOLTAGE, Integer.MIN_VALUE);
			String voltageString = "Napicie: " + voltage;
			Log.i(TAG, voltageString);
			
			String s = healthString + "\n";
			s += levelString + "\n";
			s += pluggedString + "\n";
			s += presentString + "\n";
			s += statusString + "\n";
			s += technologyString + "\n";
			s += temperatureString + "\n";
			s += voltageString;
			mBatteryTextView.setText(s);
			
			int id = intent.getIntExtra(EXTRA_ICON_SMALL, 0);
			setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, id);
		} else {
			String s = "Brak informacji o baterii";
			Log.i(TAG, s);
			mBatteryTextView.setText(s);
			
			setFeatureDrawable(Window.FEATURE_LEFT_ICON, null);
		}
	}
	
	private void showBatteryInfo() {
		// Odbiornik nie jest potrzebny
		Intent intent = registerReceiver(null, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
		showBatteryInfo(intent);
	}
	
	private void showNetworkInfoToast(final NetworkInfo info) {
		Toast.makeText(this, info.toString(), Toast.LENGTH_LONG).show();
	}

	private void showNetworkInfoToast() {
		ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
		
		// Wywietlanie tylko aktywnych pocze
		NetworkInfo info = cm.getActiveNetworkInfo();
		if (info != null) {
			Toast.makeText(this, "Aktywne: " + info.toString(), Toast.LENGTH_LONG).show();
		}
		
		// Wywietlanie wszystkich pocze
		NetworkInfo[] array = cm.getAllNetworkInfo();
		if (array != null) {
			String s = "Wszystkie: ";
			for (NetworkInfo i: array) {
				s += i.toString() + "\n";
			}
			Toast.makeText(this, s, Toast.LENGTH_LONG).show();
		}
		
		Log.i(TAG, "Ustawienia transferu danych w tle: " + cm.getBackgroundDataSetting());
	}
	
	private void transferData(byte[] array) {
		ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
		boolean backgroundDataSetting = cm.getBackgroundDataSetting(); // W Androidzie 4.0 uznane za przestarzae
		if (backgroundDataSetting) {
			// Transfer danych
		} else {
			// Uwzgldnianie ustawienia i rezygnacja z transferu
		}
	}
	
	private void updateConnectivityTextView() {
		ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo[] infoArray = cm.getAllNetworkInfo();
		if (infoArray != null) {
			String s = "";
			for (NetworkInfo info: infoArray) {
				s += info.toString() + "\n";
			}
			mConnectivityTextView.setText(s);
		}
	}
	
	private void showConnectivityInfo(Intent intent) {
		NetworkInfo info = (NetworkInfo) intent.getParcelableExtra(ConnectivityManager.EXTRA_NETWORK_INFO);
		showNetworkInfoToast(info);
		updateConnectivityTextView();
	}
	
	private void createBatteryReceiver() {
		mBatteryChangedReceiver = new BroadcastReceiver() {

			@Override
			public void onReceive(Context context, Intent intent) {
				showBatteryInfo(intent);
			}
        };
	}
	
	private void createConnectivityReceiver() {
		mConnectivityChangedReceiver = new BroadcastReceiver() {

			@Override
			public void onReceive(Context context, Intent intent) {
				showConnectivityInfo(intent);
			}
        };
	}
	
	private void backgroundDataSettingChanged() {
		ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
		boolean backgroundDataSetting = cm.getBackgroundDataSetting();
		
		if (backgroundDataSetting) {
			// Wznawianie lub rozpoczynanie transferu
		} else {
			// Wstrzymywanie lub anulowanie transferu
		}
	}
	
	private void createBackgroundDataSettingReceiver() {
		mBackgroundDataSettingReceiver = new BroadcastReceiver() {

			@Override
			public void onReceive(Context context, Intent intent) {
				backgroundDataSettingChanged();
			}
        };
	}
	
    /** Wywoywana, kiedy aktywno jest tworzona po raz pierwszy. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_LEFT_ICON);
        setContentView(R.layout.main);
        
        mBatteryTextView = (TextView) findViewById(R.id.battery);
        mConnectivityTextView = (TextView) findViewById(R.id.connectivity);
        
        transferData(null);
        
        showBatteryInfo(); // Odbiornik nie jest potrzebny
        
        showNetworkInfoToast();
        
		mLocationListener = new LocationListener() {

			@Override
			public void onLocationChanged(Location location) {
				Log.i(TAG, location.toString());
			}

			@Override
			public void onProviderDisabled(String provider) {
				Log.i(TAG, provider + " dostawca zosta wyczony");
			}

			@Override
			public void onProviderEnabled(String provider) {
				Log.i(TAG, provider + " dostawca zosta wczony");
			}

			@Override
			public void onStatusChanged(String provider, int status, Bundle extras) {
				Log.i(TAG, provider + " zmiana stanu dostawcy na " + status);
			}
		};

		Location lastKnownLocation = getLastKnownLocation();
		if (lastKnownLocation != null) {
			long age = (System.currentTimeMillis() - lastKnownLocation.getTime() + 500) / 1000;
			Log.i(TAG, "Ostatnia znana lokalizacja " + lastKnownLocation + ". Ile sekund temu uzyskana? " + age);
		}
        //requestLocationUpdates();
        //requestPassiveLocationUpdates();
        
        showLocationProvidersPowerRequirement();
        
        getMyLocationProvider();
    }

	@Override
	protected void onPause() {
		super.onPause();
		unregisterReceiver(mBatteryChangedReceiver);
		unregisterReceiver(mConnectivityChangedReceiver);
		unregisterReceiver(mBackgroundDataSettingReceiver);
		unregisterSensorEventListener(mSensorEventListener);
		mSensorEventListener = null;
		enableBatteryReceiver(false);
		
		// Wyrejestrowanie odbiornikw w czasie, kiedy aplikacja nie dziaa na pierwszym planie,
		// pozwala oszczdza energi
	}

	@Override
	protected void onResume() {
		super.onResume();
		if (mBatteryChangedReceiver == null) {
			createBatteryReceiver();
		}
		if (mConnectivityChangedReceiver == null) {
			createConnectivityReceiver();
		}
		if (mBackgroundDataSettingReceiver == null) {
			createBackgroundDataSettingReceiver();
		}
		registerReceiver(mBatteryChangedReceiver, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
		registerReceiver(mConnectivityChangedReceiver, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
		registerReceiver(mBackgroundDataSettingReceiver, new IntentFilter(ConnectivityManager.ACTION_BACKGROUND_DATA_SETTING_CHANGED));
		mSensorEventListener = registerWithAccelerometer();
		enableBatteryReceiver(true);
		updateConnectivityTextView();
		
		setupAlarm(false);
	}

	@Override
	public void onLowMemory() {
		super.onLowMemory();
		unregisterReceiver(mBatteryChangedReceiver);
		mBatteryChangedReceiver = null;
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		disableLocationListener();
	}
}