package com.apress.proandroid;

public class MyRecords {
	private MyRecord[] records;
    int nbRecords;

    public MyRecords (int size) {
        records = new MyRecord[size];
    }

    public int addRecord (short id, short value) {
        int index;
        if (nbRecords < records.length) {
            index = nbRecords;
            records[nbRecords] = new MyRecord(id, value);
            nbRecords++;
        } else {
            index = -1;
        }
        return index;
    }

    public void deleteRecord (int index) {
        if (index < 0) {
            // Zgaszanie wyjtku  nieprawidowy argument
        }
        if (index < nbRecords) {
            nbRecords--;
            records[index] = records[nbRecords];
            records[nbRecords] = null; // Naley pamita o usuniciu referencji
        }
    }

    public int sumValues (int id) {
        int sum = 0;
        for (int i = 0; i < nbRecords; i++) {
        	MyRecord r = records[i];
            if (r.getId() == id) {
                sum += r.getValue();
            }
            /*
             * Gdyby id i value byy polami publicznymi, mona by napisa kod:
             * if (r.id == id) sum += r.value;
             */
            
        }
        return sum;
    }

    public void doSomethingWithAllRecords () {
        for (int i = 0; i < nbRecords; i++) {
            records[i].doSomething();
        }
    }

}
