 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.12.4

#include <iostream>
#include <string>
#include <tuple>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
// klasa "cudza", nie mamy dostępu do jej definicji
class Tduet_cudzy												// `1
{
private:
	string nazwa;
	char bardzo_prywatny;
	double liczba;
public:
	Tduet_cudzy(string nazwa_, double liczba_) :
							nazwa(nazwa_), bardzo_prywatny('p'), liczba(liczba_)
	{ }
	//--------------------------------------
	string daj_nazwe() { 											// `2
		return nazwa;
	}
	double daj_liczbe() {											// `3
		return liczba;
	}
};
/////////////////////////////////////////////////////////////////////////////////////////
// nie mamy dostępu do klasy, więc pomocnicze funkcje get definiujemy jako globalne
// w nich skorzystamy z publicznych funkcji składowych udostępniających nam wartości
// składników danych tej klasy.
template<int Nr>  					// szablon funkcji get
decltype(auto) get(Tduet_cudzy duet)								// `4
{
	static_assert(Nr == 0 || Nr == 1);  	 	// sprawdzamy, czy na pewno 0 lub 1

	if constexpr (Nr == 0)	{
		return duet.daj_nazwe(); 		// wersja dla get<0>
	}
	else if constexpr (Nr == 1) {
		return duet.daj_liczbe();			// wersja dla get<1>
	}
}
//*******************************************************************
template< >
struct std::tuple_size<Tduet_cudzy>									// `5
{
	static const size_t value = 2;
};
/////////////////////////////////////////////////////////////////////////////////////////
// specjalizacje, które określą typ dowiązywanych składników
// -------------------------------- Specjalizacja dla dowiązania 0 ---
template< >
struct std::tuple_element<0, Tduet_cudzy>							// `6
{
	using type = string;
};
/////////////////////////////////////////////////////////////////////////////////////////
// -------------------------------- specjalizacja dla dowiązania 1 ---
template< >
struct std::tuple_element<1, Tduet_cudzy>							 // `7
{
	using type = double;
};
//*******************************************************************
int main()
{
	Tduet_cudzy obj2 {"Wenus", 3.14};								// `8
	auto [dn, dl] = obj2;											// `9
	dn= "AFRODYTA"; 											// `10
	dl = 1.23;
	cout << "dn = " << dn << ", dl = " << dl;
	cout << ", oryginal obj2 ("	<< obj2.daj_nazwe() << ", " << obj2.daj_liczbe() << ")\n";
}
