 // Misja w nadprzestrzeń C++14/17, program z paragrafu 3.3.2


#include <iostream>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
class alignas(32) Twektorek												// `1
{
public :
	double x, y, z;
	//--- konstruktor -----
	Twektorek (double a=0, double b=0, double c=0) : x (a), y (b), z(c)
	{
	}
	//---------------------------------------------
	void wypisz_zawartosc() {
		cout << "\t zawartosc x= "<< x << ", y= "<< y <<", z= "<< z << endl;
	}

	// przeładowanie operatorów new i delete na użytek tej klasy
	void * operator new (size_t rozmiar, align_val_t 	w);
	void * operator new[ ] (size_t rozmiar, align_val_t w);

	void operator delete (void * wsk, size_t rozmiar, align_val_t wyrownanie);
	void operator delete[ ] (void * wsk, size_t rozmiar, align_val_t wyrownanie);
};
/////////////////////////////////////////////////////////////////////////////////////////
void * Twektorek::operator new ( size_t rozmiar, align_val_t  wyrownanie)  		// `2
{
	cout << "\t(nA) new(rozmiar = " 	<< rozmiar <<", wyrownanie = "
		 << static_cast<size_t>( wyrownanie) << ")" << endl;

	return ( aligned_alloc(static_cast<size_t>( wyrownanie), rozmiar));
}
//*******************************************************************
void * Twektorek::operator new[ ] (size_t rozmiar, align_val_t wyrownanie)		// `3
{
	cout << "\t(nB) new[ ] (rozmiar = " << rozmiar
		 << ", wyrownanie " << static_cast<size_t>( wyrownanie) <<endl;
	return (aligned_alloc(static_cast<size_t>( wyrownanie), rozmiar) );
}
//*******************************************************************
void  Twektorek::operator delete (void * wsk, size_t rozmiar, align_val_t wyrownanie)	// `4
{
	if ( wsk ) {
		cout << "\t(dA) delete (void *, rozmiar = " << rozmiar
			 << ", wyrownanie = " << static_cast<size_t>( wyrownanie)<< ")" << endl;
		// nasze własne akcje, a potem...
		free(wsk);
	}
}
//*******************************************************************
void Twektorek::operator delete[ ] (void * wsk, size_t rozmiar, align_val_t wyrownanie) 	// `5
{
	if(wsk) {
		cout << "\t(dB) delete[](void * wsk, rozmiar = "<< rozmiar
			 << ", wyrownanie =" << static_cast<size_t>( wyrownanie) << ")" << endl ;
		free( wsk );
	}
}
//*******************************************************************
int main()
{
	cout << "Wyrownanie klasy Twektorek zostalo ustawione na " << alignof(Twektorek) <<endl;

	cout << "Wytworzenie pojedynczego obiektu \n";
	auto *w1 = new Twektorek ( 1, 1, 1 ); 									// `6
	w1->wypisz_zawartosc();
	delete w1;														// `7

	cout << "Rezerwacja tablicy trzech wektorkow" << endl;

	Twektorek * wtab = new Twektorek[3];									// `8
	for ( int i = 0; i < 3 ; ++i ) {
		wtab[i].wypisz_zawartosc();
	}
	delete [ ] wtab;													// `9
}

