 // Misja w nadprzestrzeń C++14/17, program z paragrafu 2.8.1

#include <iostream>
#include <memory>
#include <cmath>
using namespace std;
//********************************************************************
constexpr  double pi = 3.141592 ;
//********************************************************************
constexpr unsigned long long silnia(int ile)									 // `1
{
	unsigned long long s = 1;
	switch(ile)						// dozwolona w C++14 instrukcja switch
	{
	case  0: case 1:
		return s;

	default:
		for(int n = 1 ; n <= ile ; ++n)  		// dozwolona w C++14 pętla for
		{
			s = s * n;
		}
		return s;
	} // koniec instrukcji switch
	return s;
}
//********************************************************************
constexpr  unsigned long long silnia_5 = silnia(5);							 // `2
//********************************************************************
constexpr double stopnie_na_radiany(double stopni)						 // `3
{
	return pi * stopni / 180.0;
}
//********************************************************************
constexpr  double sinus_stopni(double x, int wyrazow = 10)					 // `4
{
	x = stopnie_na_radiany(x) ;											 // `5

	double wynik { };													 // `6

	for(int n = 0 ; n <= wyrazow ; ++n)									 // `7
	{
		int znak_wyrazu = ( (n%2) ? (-1) : (1) ) ; 							   // `8
		int wykladnik = (2*n +1); 										 // `9

		long double potega_x = x;
		for(int i = 1 ; i < wykladnik ; i++)		// obliczenie potęgi  x			 // `10
		{
			potega_x *= x;
		}
		double wyraz_ciagu  = znak_wyrazu * potega_x / silnia(wykladnik);		 // `11
		wynik += wyraz_ciagu;  											 // `12
	}
	return wynik;														 // `13
}
//********************************************************************
constexpr double  sinus_30 = sinus_stopni(30);								 // `14
constexpr double  sinus_45 = sinus_stopni(45);
constexpr double  sinus_60 = sinus_stopni(60);
constexpr double  sinus_90 = sinus_stopni(90);
constexpr double  sinus_120 = sinus_stopni(120);
constexpr double  sinus_180 = sinus_stopni(180);

constexpr  double tablica_sinusow[ ]  			// co 2.5 stopnia  				 // `15
{
	sinus_stopni(0),
	sinus_stopni(2.5),
	sinus_stopni(5),
	sinus_stopni(7.5),
	sinus_stopni(10)
	// i tak dalej
};
//********************************************************************
int main()
{
	constexpr  unsigned long long silnia_8 = silnia(8);						 // `16
	// Te silnie i sinusy powinny już być obliczone w trakcie kompilacji
	cout << "silnia_5 = " << silnia_5 << ", silnia_8 = " << silnia_8 << endl;		 // `17

	cout << "sinus_30 = " << sinus_30
		<< "\tsinus_45 = " << sinus_45
		<< "\tsinus_60 = " << sinus_60
		<< "\nsinus_90 = " << sinus_90
		<< "\tsinus_120 = " << sinus_120
		<< "\tsinus_180 = " << sinus_180
		<< endl;

	for(int elem = 0 ; elem < 5 ; ++elem)
	{
		cout << "tablica_sinusow[" << elem << "] = " << tablica_sinusow[elem] << endl;	 // `18
	}
	cout << "Oczywiscie funkcji constexpr wolno uzyc rowniez jako zwyklej\n";
	for(int kat = 0 ;  kat <= 180 ; kat += 45)
	{
		double wynik = sinus_stopni(kat);									 // `19
		cout << "kat " << kat << " stopni, \tsinus = " << wynik  << endl;;
	}
}

