 // Misja w nadprzestrzeń C++14/17, program z paragrafu 2.7.3

#include <iostream>
#include <memory>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
struct Tklasa															 // `1
{
	int skladnik = 0;
	~Tklasa() {
	    cout << "Destruktor ~Tklasa" << endl;									 // `2
    }
};
 // `@

 // `@
//*******************************************************************
int main()
{
	cout << "Definicja sprytnego wskaznika do pojedynczego obiektu\n";
	unique_ptr<Tklasa>	spryt { new Tklasa };	 							   // `3

		{   // lokalny zakres w celach szkoleniowych -------------------				 // `4

		auto lambda1 = [sw = std::move(spryt) ] ()						 // `5
			{
					sw->skladnik = 4;
		    		cout << "Wykonuje sie lambda1" << endl;
        	};															 // `6

		if(!spryt)														 // `7
			cout << "A teraz obiekt spryt  NIE ma juz prawa wlasnosci " << endl;

		cout << "Przed wykonaniem lambdy" << endl;
		lambda1();   				// 1. wykonanie lambdy					 // `8
		lambda1();   				// 2. wykonanie lambdy

		cout << "--- Teraz nastapi koniec zakresu istnienia lambdy1\n";
    	}   // koniec lokalnego zakresu -------------------------					 // `9
  	cout << "--- Skonczyl sie zakres istnienia lambdy1\n";

	cout << "PROBY Z TABLICA" << endl;

	// sprytny wskaźnik do tablicy 5-elementowej (z rezerwacją tej tablicy)
	constexpr int rozmiar = 5;
	unique_ptr<Tklasa[]>    wsktab { new Tklasa[rozmiar] };					 // `10

	{   // drugi lokalny  zakres (w celach szkoleniowych) ============= 		 // `11

		auto lamTab = [stab = std::move(wsktab),   rozmiar] ()				 // `12
		{
			for(int i = 0 ; i < rozmiar ; ++i){
					stab[i].skladnik = i;
			}
			cout << "Pracuje lamTab\n";
			};															 // `13

		cout << "Przed wywolaniem lamTab\n";
		lamTab();													 // `14
		lamTab();
		cout << "=== Zakonczyl sie obszar istnienia lamTab" << endl;
	}   // koniec lokalnego zakresu ============================ 	 // `15
	cout << "=== Koniec funkcji main" << endl;
}
