 // Misja w nadprzestrzeń C++14/17, program z paragrafu 2.6

#include <iostream>
#include <string>
using namespace std;
#include <stdio.h>   						// dla funkcji printf				 // `1
// przeładowanie globalnych operatorów
// dla pojedynczych obiektów ----------------------------------------------
void * operator new(size_t rozmiar)										 // `2
{
	printf("\tnew  pojedynczy obiekt, rozmiar %lu bajtow\n", (unsigned long) rozmiar); 	 // `3
	void *wsk = malloc(rozmiar);											 // `4
	if(!wsk) throw std::bad_alloc();										 // `5
	return wsk;														 // `6
}
//*******************************************************************
void operator delete(void * wsk) noexcept									 // `7
{
	printf("\tdelete pojedynczy obiekt\n");
	free(wsk);
}
//*******************************************************************
// nowość w C++14:  delete z dodatkowym argumentem określającym rozmiar
void operator delete (void * wsk, std::size_t rozmiar) noexcept					 // `8
{
	printf("\tdelete (void * wsk, size_t rozmiar = %lu bajtow)\n", rozmiar);
	free(wsk);
}
//---DLA TABLIC ----------------------------------------------------------
void * operator new[ ](std::size_t rozmiar)  									 // `9
{
	printf("\tnew[ ](size_t rozmiar = %lu bajtow)\n", rozmiar);
	void *wsk = malloc(rozmiar);
	if(!wsk) throw std::bad_alloc();
	return wsk;
}
//*******************************************************************
void operator delete[ ](void * wsk)  noexcept  // (1 zwykłe)					 // `10
{
	printf("\tdelete [ ] (void*);     <-> bez arg. 'rozmiar'\n");
	free(wsk);
}
//*******************************************************************
// nowość w C++14:  delete[] z dodatkowym argumentem określającym rozmiar -----------
void operator delete [ ](void * wsk, unsigned long   rozmiar) 	noexcept   		 // `11
{
	printf("\tdelete [ ](void * wsk, size_t rozmiar = %lu bajtow)\n", rozmiar);
	free(wsk);
}
//*******************************************************************
// przykładowa klasa użytkownika
struct Tjonizator														 // `12
{
	char znaki[50];

	Tjonizator()
	{
		cout << "\t\tKonstruktor Tjonizatora\n" ;
	}
	//-------------------------
	~Tjonizator()   						// ma destruktor
	{
		cout << "\t\tdestruktor Tjonizatora \n" ;
	}
};
//*******************************************************************
int main()
{
	try {
		cout << "Proby z pojedynczymi obiektami------------------------\n";

		cout << "a) Pojedynczy obiekt (int ma rozmiar " << sizeof(int) << " bajtow)\n" ;

		int * wsk = new int; 											 // `13
		delete wsk;													 // `14

		cout << "b) Obiekt klasy Tjonizator  (ma rozmiar " << sizeof(Tjonizator) << " bajtow)\n";
		Tjonizator * w = new Tjonizator;									 // `15
		delete w;														 // `16

		cout << "\nProby z tablicami obiektow----------------------------\n" ;

		cout << "c) Tablica int[10]\n";
		int *tablica = new int[10];										 // `17
		delete [] tablica;												 // `18

		cout << "d) Tablica Tjonizator[3]\n";
	 	auto tab = new Tjonizator [3];  									  // `19
		delete []  tab;													 // `20
	}
	catch(bad_alloc)
	{
		cout << "Niepowodzenie w trakcie rezerwacji pamieci" << endl;
	}
}
